// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HonorWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HonorWAddonDeed();
			}
		}

		[ Constructable ]
		public HonorWAddon()
		{
			AddComponent( new AddonComponent( 5321 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5322 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5319 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5320 ), 0, 1, 0 );
		}

		public HonorWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HonorWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HonorWAddon();
			}
		}

		[Constructable]
		public HonorWAddonDeed()
		{
			Name = "Honor West";
		}

		public HonorWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}