// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HumilityNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HumilityNAddonDeed();
			}
		}

		[ Constructable ]
		public HumilityNAddon()
		{
			AddComponent( new AddonComponent( 5333 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5334 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5331 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5332 ), 0, 1, 0 );
		}

		public HumilityNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HumilityNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HumilityNAddon();
			}
		}

		[Constructable]
		public HumilityNAddonDeed()
		{
			Name = "Humility North";
		}

		public HumilityNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}