// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HumilityWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new HumilityWAddonDeed();
			}
		}

		[ Constructable ]
		public HumilityWAddon()
		{
			AddComponent( new AddonComponent( 5327 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5328 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5329 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5330 ), 1, 0, 0 );
		}

		public HumilityWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class HumilityWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new HumilityWAddon();
			}
		}

		[Constructable]
		public HumilityWAddonDeed()
		{
			Name = "Humility West";
		}

		public HumilityWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}