// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class JusticeNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new JusticeNAddonDeed();
			}
		}

		[ Constructable ]
		public JusticeNAddon()
		{
			AddComponent( new AddonComponent( 5302 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5301 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5300 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5299 ), 0, 0, 0 );
		}

		public JusticeNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class JusticeNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new JusticeNAddon();
			}
		}

		[Constructable]
		public JusticeNAddonDeed()
		{
			Name = "Justice North";
		}

		public JusticeNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}