// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class JusticeWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new JusticeWAddonDeed();
			}
		}

		[ Constructable ]
		public JusticeWAddon()
		{
			AddComponent( new AddonComponent( 5297 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5296 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5295 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5298 ), 1, 0, 0 );
		}

		public JusticeWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class JusticeWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new JusticeWAddon();
			}
		}

		[Constructable]
		public JusticeWAddonDeed()
		{
			Name = "Justice West";
		}

		public JusticeWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}