// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class SacrificeNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new SacrificeNAddonDeed();
			}
		}

		[ Constructable ]
		public SacrificeNAddon()
		{
			AddComponent( new AddonComponent( 5391 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5390 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5393 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5392 ), 1, 1, 0 );
		}

		public SacrificeNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class SacrificeNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new SacrificeNAddon();
			}
		}

		[Constructable]
		public SacrificeNAddonDeed()
		{
			Name = "Sacrifice North";
		}

		public SacrificeNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}