// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class SacrificeWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new SacrificeWAddonDeed();
			}
		}

		[ Constructable ]
		public SacrificeWAddon()
		{
			AddComponent( new AddonComponent( 5388 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5387 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5386 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5389 ), 1, 0, 0 );
		}

		public SacrificeWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class SacrificeWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new SacrificeWAddon();
			}
		}

		[Constructable]
		public SacrificeWAddonDeed()
		{
			Name = "Sacrifice West";
		}

		public SacrificeWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}