// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class SpiritualityNAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new SpiritualityNAddonDeed();
			}
		}

		[ Constructable ]
		public SpiritualityNAddon()
		{
			AddComponent( new AddonComponent( 5316 ), 0, 1, 0 );
			AddComponent( new AddonComponent( 5315 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5318 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5317 ), 1, 1, 0 );
		}

		public SpiritualityNAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class SpiritualityNAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new SpiritualityNAddon();
			}
		}

		[Constructable]
		public SpiritualityNAddonDeed()
		{
			Name = "Spirituality North";
		}

		public SpiritualityNAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}