// Created by Ice
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class SpiritualityWAddon : BaseAddon
	{
		public override BaseAddonDeed Deed
		{
			get
			{
				return new SpiritualityWAddonDeed();
			}
		}

		[ Constructable ]
		public SpiritualityWAddon()
		{
			AddComponent( new AddonComponent( 5311 ), 0, 0, 0 );
			AddComponent( new AddonComponent( 5314 ), 1, 0, 0 );
			AddComponent( new AddonComponent( 5313 ), 1, 1, 0 );
			AddComponent( new AddonComponent( 5312 ), 0, 1, 0 );
		}

		public SpiritualityWAddon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class SpiritualityWAddonDeed : BaseAddonDeed
	{
		public override BaseAddon Addon
		{
			get
			{
				return new SpiritualityWAddon();
			}
		}

		[Constructable]
		public SpiritualityWAddonDeed()
		{
			Name = "Spirituality West";
		}

		public SpiritualityWAddonDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( 0 ); // Version
		}

		public override void	Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}