using System;
using Server;

namespace Server.Items
{
	public class ArmorOfFortune : StuddedChest
	{
		public override int LabelNumber{ get{ return 1061098; } } // Armor of Fortune
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		[Constructable]
		public ArmorOfFortune()
		{
			Hue = 0x501;
			Attributes.LowerRegCost = 40;
			Attributes.RegenMana = 4;
			ArmorAttributes.MageArmor = 1;
			IsUWItem = true;
			ProtectionLevel = ArmorProtectionLevel.Guarding;
			Durability = ArmorDurabilityLevel.Durable;
		}

		public ArmorOfFortune( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}