using System;
using Server;

namespace Server.Items
{
	public class GauntletsOfNobility : RingmailGloves
	{
		public override int LabelNumber{ get{ return 1061092; } } // Gauntlets of Nobility
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public GauntletsOfNobility()
		{
			Hue = 0x4FE;
			Attributes.BonusStr = 8;
			Attributes.BonusHits = 10;
			IsUWItem = true;
			ProtectionLevel = ArmorProtectionLevel.Hardening;
			Durability = ArmorDurabilityLevel.Fortified;
		}

		public GauntletsOfNobility( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version < 1 )
			{
				if ( Hue == 0x562 )
					Hue = 0x4FE;

				PhysicalBonus = 0;
				PoisonBonus = 0;
			}
		}
	}
}