using System;
using Server;

namespace Server.Items
{
	public class InquisitorsResolution : PlateGloves
	{
		public override int LabelNumber{ get{ return 1060206; } } // The Inquisitor's Resolution
		public override int ArtifactRarity{ get{ return 10; } }

		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public InquisitorsResolution()
		{
			Hue = 0x4F2;
			Attributes.CastRecovery = 3;
			Attributes.LowerManaCost = 8;
			ArmorAttributes.MageArmor = 1;
			SkillBonuses.SetValues( 0, SkillName.Meditation, 10 );
			IsUWItem = true;
			ProtectionLevel = ArmorProtectionLevel.Defense;
			Durability = ArmorDurabilityLevel.Durable;
		}

		public InquisitorsResolution( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version < 1 )
			{
				ColdBonus = 0;
				EnergyBonus = 0;
			}
		}
	}
}