//Scripted by Midnight Dragon
using System;
using Server;

namespace Server.Items
{	
	public class MarkOfTravesty : SavageMask
	{
		public override int LabelNumber{ get{ return 1074493; } } // Mark of Travesty
		
		public override int BasePhysicalResistance{ get{ return 8; } }
		public override int BaseFireResistance{ get{ return 5; } }
		public override int BaseColdResistance{ get{ return 11; } }
		public override int BasePoisonResistance{ get{ return 20; } }
		public override int BaseEnergyResistance{ get{ return 15; } }
	
		[Constructable]
		public MarkOfTravesty() : base()
		{
			Hue = 0x495;
			
			Attributes.BonusMana = 8;
			Attributes.RegenHits = 3;
			
			ClothingAttributes.SelfRepair = 3;

			switch ( Utility.Random( 94 ))
			{  
//---------------------------------------Begin Random Skill Groups------------------------------------------------// 
//--Warrior Skill Group-------------------------------------------------------------------------------------------//                                 
            			case 0:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;

            			case 1:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;

            			case 2:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break;

            			case 3:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Chivalry, 10.0 ); break;

            			case 4:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break;

            			case 5:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Focus, 10.0 ); break;

            			case 6:  SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Bushido, 10.0 ); break;

            			case 7:  SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;

            			case 8:  SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;

            			case 9:  SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break;

            			case 10: SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Chivalry, 10.0 ); break;

            			case 11: SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break;

            			case 12: SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Focus, 10.0 ); break;

            			case 13: SkillBonuses.SetValues( 0, SkillName.Swords, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Bushido, 10.0 ); break;

            			case 14: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;

            			case 15: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;

            			case 16: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break; 

            			case 17: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Chivalry, 10.0 ); break;

            			case 18: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break;

            			case 19: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Focus, 10.0 ); break;  

            			case 20: SkillBonuses.SetValues( 0, SkillName.Macing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Bushido, 10.0 ); break;

            			case 21: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;

            			case 22: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;

            			case 23: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break;

            			case 24: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Chivalry, 10.0 ); break;

            			case 25: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break;

            			case 26: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Focus, 10.0 ); break;

            			case 27: SkillBonuses.SetValues( 0, SkillName.Fencing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Bushido, 10.0 ); break;

            			case 28: SkillBonuses.SetValues( 0, SkillName.Wrestling, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;

            			case 29: SkillBonuses.SetValues( 0, SkillName.Wrestling, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;

            			case 30: SkillBonuses.SetValues( 0, SkillName.Wrestling, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Focus, 10.0 ); break;

            			case 31: SkillBonuses.SetValues( 0, SkillName.Focus, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Chivalry, 10.0 ); break;

            			case 32: SkillBonuses.SetValues( 0, SkillName.Focus, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Bushido, 10.0 ); break;

            			case 33: SkillBonuses.SetValues( 0, SkillName.Anatomy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 ); break;
//--Spell Casting Skill Group-------------------------------------------------------------------------------------//
            			case 34: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.MagicResist, 10.0 ); break;

            			case 35: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.EvalInt, 10.0 ); break;

            			case 36: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break; 

            			case 37: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.SpiritSpeak, 10.0 ); break;

            			case 38: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Inscribe, 10.0 ); break;

            			case 39: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 40: SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break;

            			case 41: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.MagicResist, 10.0 ); break;

            			case 42: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.EvalInt, 10.0 ); break;

            			case 43: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Poisoning, 10.0 ); break;

            			case 44: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.SpiritSpeak, 10.0 ); break;

            			case 45: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Inscribe, 10.0 ); break;

            			case 46: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 47: SkillBonuses.SetValues( 0, SkillName.Necromancy, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Parry, 10.0 ); break;

            			case 48: SkillBonuses.SetValues( 0, SkillName.Spellweaving, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.MagicResist, 10.0 ); break;

            			case 49: SkillBonuses.SetValues( 0, SkillName.Spellweaving, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.EvalInt, 10.0 ); break;

            			case 50: SkillBonuses.SetValues( 0, SkillName.Spellweaving, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 51: SkillBonuses.SetValues( 0, SkillName.Spellweaving, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Inscribe, 10.0 ); break;

            			case 52: SkillBonuses.SetValues( 0, SkillName.MagicResist, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.EvalInt, 10.0 ); break;

            			case 53: SkillBonuses.SetValues( 0, SkillName.MagicResist, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.SpiritSpeak, 10.0 ); break;

            			case 54: SkillBonuses.SetValues( 0, SkillName.MagicResist, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 55: SkillBonuses.SetValues( 0, SkillName.EvalInt, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.SpiritSpeak, 10.0 ); break;

            			case 56: SkillBonuses.SetValues( 0, SkillName.EvalInt, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Inscribe, 10.0 ); break; 

            			case 57: SkillBonuses.SetValues( 0, SkillName.EvalInt, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 58: SkillBonuses.SetValues( 0, SkillName.SpiritSpeak, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Inscribe, 10.0 ); break;

            			case 59: SkillBonuses.SetValues( 0, SkillName.SpiritSpeak, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;

            			case 60: SkillBonuses.SetValues( 0, SkillName.Inscribe, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Meditation, 10.0 ); break;
//--Crafting Skill Group------------------------------------------------------------------------------------------//
            			case 61: SkillBonuses.SetValues( 0, SkillName.Blacksmith, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Mining, 10.0 ); break;

            			case 62: SkillBonuses.SetValues( 0, SkillName.Blacksmith, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tinkering, 10.0 ); break;

            			case 63: SkillBonuses.SetValues( 0, SkillName.Blacksmith, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Fletching, 10.0 ); break;

            			case 64: SkillBonuses.SetValues( 0, SkillName.Blacksmith, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Carpentry, 10.0 ); break;

            			case 65: SkillBonuses.SetValues( 0, SkillName.Blacksmith, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tailoring, 10.0 ); break;

            			case 66: SkillBonuses.SetValues( 0, SkillName.Carpentry, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Lumberjacking, 10.0 ); break;

            			case 67: SkillBonuses.SetValues( 0, SkillName.Carpentry, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Fletching, 10.0 ); break;

            			case 68: SkillBonuses.SetValues( 0, SkillName.Carpentry, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Tinkering, 10.0 ); break;

            			case 69: SkillBonuses.SetValues( 0, SkillName.Inscribe, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Cartography, 10.0 ); break;

            			case 70: SkillBonuses.SetValues( 0, SkillName.Inscribe, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Alchemy, 10.0 ); break;
//--Misc Fighters Skill Group-------------------------------------------------------------------------------------//
            			case 71: SkillBonuses.SetValues( 0, SkillName.Ninjitsu, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Stealth, 10.0 ); break;
//--Tamers Skill Group--------------------------------------------------------------------------------------------//
            			case 72: SkillBonuses.SetValues( 0, SkillName.AnimalTaming, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Veterinary, 10.0 ); break;

            			case 73: SkillBonuses.SetValues( 0, SkillName.AnimalTaming, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.AnimalLore, 10.0 ); break;

            			case 74: SkillBonuses.SetValues( 0, SkillName.AnimalTaming, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Musicianship, 10.0 ); break;

            			case 75: SkillBonuses.SetValues( 0, SkillName.AnimalTaming, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Magery, 10.0 ); break;

            			case 76: SkillBonuses.SetValues( 0, SkillName.Veterinary, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.AnimalLore, 10.0 ); break; 
//--Bard Skill Group----------------------------------------------------------------------------------------------//
            			case 77: SkillBonuses.SetValues( 0, SkillName.Musicianship, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Peacemaking, 10.0 ); break;

            			case 78: SkillBonuses.SetValues( 0, SkillName.Musicianship, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Discordance, 10.0 ); break;

            			case 79: SkillBonuses.SetValues( 0, SkillName.Musicianship, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Provocation, 10.0 ); break;

            			case 81: SkillBonuses.SetValues( 0, SkillName.Peacemaking, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Provocation, 10.0 ); break;

            			case 82: SkillBonuses.SetValues( 0, SkillName.Peacemaking, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Discordance, 10.0 ); break;

            			case 83: SkillBonuses.SetValues( 0, SkillName.Provocation, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Discordance, 10.0 ); break;
//--Misc Skill Group----------------------------------------------------------------------------------------------//
            			case 84: SkillBonuses.SetValues( 0, SkillName.EvalInt, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;
//--Misc Support Skill Group--------------------------------------------------------------------------------------//
            			case 85: SkillBonuses.SetValues( 0, SkillName.Healing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Anatomy, 10.0 ); break;
//--T Hunter Skill Group------------------------------------------------------------------------------------------//
            			case 86: SkillBonuses.SetValues( 0, SkillName.Lockpicking, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.RemoveTrap, 10.0 ); break;

            			case 87: SkillBonuses.SetValues( 0, SkillName.Lockpicking, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Cartography, 10.0 ); break;
//--Rogue Skill Group---------------------------------------------------------------------------------------------//
            			case 88: SkillBonuses.SetValues( 0, SkillName.Stealing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Snooping, 10.0 ); break;

            			case 89: SkillBonuses.SetValues( 0, SkillName.Stealing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Stealth, 10.0 ); break;

            			case 90: SkillBonuses.SetValues( 0, SkillName.Stealing, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Hiding, 10.0 ); break;

            			case 91: SkillBonuses.SetValues( 0, SkillName.Hiding, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Snooping, 10.0 ); break;

            			case 92: SkillBonuses.SetValues( 0, SkillName.Hiding, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Stealth, 10.0 ); break;

            			case 93: SkillBonuses.SetValues( 0, SkillName.Snooping, 10.0 );
					 SkillBonuses.SetValues( 1, SkillName.Stealth, 10.0 ); break;
//---------------------------------------End Random Skill Groups--------------------------------------------------//
			}
		}

		public MarkOfTravesty( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}