using System;
using Server;

namespace Server.Items
{
	public class MidnightBracers : BoneArms
	{
		public override int LabelNumber{ get{ return 1061093; } } // Midnight Bracers
		public override int ArtifactRarity{ get{ return 11; } }

		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public MidnightBracers()
		{
			Hue = 0x455;
			SkillBonuses.SetValues( 0, SkillName.EvalInt, 20.0 );
			Attributes.BonusInt = 5;
			ArmorAttributes.MageArmor = 1;
			IsUWItem = true;
			Durability = ArmorDurabilityLevel.Indestructible;
			ProtectionLevel = ArmorProtectionLevel.Guarding;
		}

		public MidnightBracers( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version < 1 )
				PhysicalBonus = 0;
		}
	}
}