using System;
using Server.Items;

namespace Server.Items
{
	[FlipableAttribute( 0x1452, 0x1457 )]
	public class DaemonLegs : BaseArmor
	{
		public override int ArtifactRarity{ get{ return 12; } }

      public override int BasePhysicalResistance{ get{ return 6; } }
		public override int BaseFireResistance{ get{ return 6; } }
		public override int BaseColdResistance{ get{ return 7; } }
		public override int BasePoisonResistance{ get{ return 5; } }
		public override int BaseEnergyResistance{ get{ return 7; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		public override int AosStrReq{ get{ return 55; } }
		public override int OldStrReq{ get{ return 40; } }

		public override int OldDexBonus{ get{ return -4; } }

		public override int ArmorBase{ get{ return 46; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Bone; } }
		public override CraftResource DefaultResource{ get{ return CraftResource.RegularLeather; } }

		public override int LabelNumber{ get{ return 1041375; } } // daemon bone leggings

		[Constructable]
		public DaemonLegs() : base( 0x1452 )
		{
			Weight = 3.0;
			Hue = 0x648;

			ArmorAttributes.SelfRepair = 1;
		}
		
		public override bool OnEquip( Mobile from )
		{
         DaemonHelm.IsFullSet( from, true, from.HeadArmor, from.HandArmor, from.ArmsArmor, this, from.ChestArmor );
         return base.OnEquip( from );
      }
      
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile from = ( Mobile ) parent;
				
            DaemonHelm.IsFullSet( from, false, from.HeadArmor, from.HandArmor, from.ArmsArmor, this, from.ChestArmor );
			}
			
			base.OnRemoved( parent );
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			DaemonHelm.ChangeNameProperties( (BaseArmor) this, list );
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			DaemonHelm.ChangeGetProperties( (BaseArmor) this, list );
		}

		public DaemonLegs( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( ArmorAttributes.SelfRepair == 0 )
				ArmorAttributes.SelfRepair = 1;
		}
	}
}