using System;
using Server;

namespace Server.Items
{
	[FlipableAttribute( 0x1451, 0x1456 )]
	public class DaemonHelm : BaseArmor
	{
		public override int ArtifactRarity{ get{ return 12; } }
		
		private int m_Bonus = 0;
		
		[CommandProperty(AccessLevel.GameMaster)]
      public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 10 ); } }
      
      public override int BasePhysicalResistance{ get{ return 6; } }
		public override int BaseFireResistance{ get{ return 6; } }
		public override int BaseColdResistance{ get{ return 7; } }
		public override int BasePoisonResistance{ get{ return 5; } }
		public override int BaseEnergyResistance{ get{ return 7; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		public override int AosStrReq{ get{ return 20; } }
		public override int OldStrReq{ get{ return 40; } }

		public override int ArmorBase{ get{ return 46; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Bone; } }
		public override CraftResource DefaultResource{ get{ return CraftResource.RegularLeather; } }

		public override int LabelNumber{ get{ return 1041374; } } // daemon bone helmet

		[Constructable]
		public DaemonHelm() : base( 0x1451 )
		{
			Hue = 0x648;
			Weight = 3.0;

			ArmorAttributes.SelfRepair = 1;
		}

		public static bool FullDeamonSetPresent( Mobile from )
		{
         if ( from.HandArmor is DaemonGloves && from.ArmsArmor is DaemonArms && from.HeadArmor is DaemonHelm && from.LegsArmor is DaemonLegs && from.ChestArmor is DaemonChest )
            return true;
         else
            return false;
      }
      
      public static void IsFullSet( Mobile from, bool equiping, Item head, Item gloves, Item shoulders, Item pants, Item breast )
      {
         if ( from.HasTrade )
            return;
            
         int EqHue = 2546; //Equiped hue
         int bonus = 0;
         DaemonHelm helm;
         BaseArmor hands, arms, legs, chest;
            
         if ( gloves is DaemonGloves && shoulders is DaemonArms && head is DaemonHelm && pants is DaemonLegs && breast is DaemonChest )
         {
            helm = (DaemonHelm) head;
            hands = (BaseArmor) gloves;
            arms = (BaseArmor) shoulders;
            legs = (BaseArmor) pants;
            chest = (BaseArmor) breast;
            
            if ( equiping )
            {
               from.PlaySound( 1150 );
               from.PlaySound( 521 );
               from.FixedParticles( 14170, 1, 10, 0x1F78, EqHue, 5, EffectLayer.Waist );
               from.SendLocalizedMessage( 1072391 ); // The magic of your armor combines to assist you!
            }
            else
            {
               from.PlaySound( 376 );
               from.PlaySound( 484 );
               from.FixedParticles( 14138, 1, 10, 0x1F78, EqHue, 5, EffectLayer.Waist );
            }
         }
         else
            return;
         
         //HELM
        if ( helm.Bonus > 0 )
           bonus = helm.Bonus;
        
        if ( bonus > 0 )
        {
           helm.EnergyBonus += SetBonus( equiping, bonus );
           helm.ColdBonus += SetBonus( equiping, bonus );
           helm.Attributes.BonusMana += SetBonus( equiping, bonus );
           helm.Attributes.BonusHits += SetBonus( equiping, bonus );
           helm.Attributes.RegenMana += SetBonus( equiping, bonus );
           helm.Attributes.LowerRegCost += SetBonus( equiping, bonus );
           helm.SkillBonuses.SetValues( 0, SkillName.Magery, ( equiping ) ? bonus : 0.0 );
        }
        
        helm.Hue = (equiping) ? EqHue : 0x648;
        helm.PhysicalBonus += SetBonus( equiping, 5 );
		  helm.FireBonus += SetBonus( equiping, 5 );
		  helm.PoisonBonus += SetBonus( equiping, 10 );
        helm.ArmorAttributes.SelfRepair += SetBonus( equiping, 2 );
        helm.ArmorAttributes.MageArmor += SetBonus( equiping, 1 );
        
        helm.Attributes.NightSight += SetBonus( equiping, 1 );        
        helm.Attributes.CastRecovery += SetBonus( equiping, 2 );
        helm.Attributes.BonusInt += SetBonus( equiping, 20 );
        helm.Attributes.Luck += SetBonus( equiping, 150 );
        helm.Attributes.SpellDamage += SetBonus( equiping, 40 );
        
        helm.InvalidateProperties();

        //HANDS
        if ( bonus > 0 )
        {
           hands.ColdBonus += SetBonus( equiping, bonus );
           hands.EnergyBonus += SetBonus( equiping, bonus );
           hands.Attributes.BonusMana += SetBonus( equiping, bonus );
           hands.Attributes.BonusHits += SetBonus( equiping, bonus );
           hands.Attributes.BonusStam += SetBonus( equiping, bonus );
           hands.Attributes.LowerRegCost += SetBonus( equiping, bonus );
           hands.Attributes.LowerManaCost += SetBonus( equiping, bonus );
           hands.Attributes.DefendChance += SetBonus( equiping, bonus );
           hands.Attributes.SpellDamage += SetBonus( equiping, bonus );
           hands.Attributes.EnhancePotions += SetBonus( equiping, bonus );
           hands.SkillBonuses.SetValues( 0, SkillName.Healing, ( equiping ) ? bonus : 0.0 );
        }
        
        hands.Hue = (equiping) ? EqHue : 0x648;
        hands.PhysicalBonus += SetBonus( equiping, 10 );
		  hands.FireBonus += SetBonus( equiping, 5 );
		  hands.PoisonBonus += SetBonus( equiping, 10 );
        hands.ArmorAttributes.SelfRepair += SetBonus( equiping, 2 );
        hands.ArmorAttributes.MageArmor += SetBonus( equiping, 1 );
        
        hands.Attributes.BonusStr += SetBonus( equiping, 20 );
        hands.Attributes.Luck += SetBonus( equiping, 250 );
        hands.Attributes.WeaponDamage += SetBonus( equiping, 40 );
        hands.Attributes.AttackChance += SetBonus( equiping, 40 );
        hands.Attributes.WeaponSpeed += SetBonus( equiping, 20 );
        
        hands.InvalidateProperties();
        
        //ARMS
        if ( bonus > 0 )
        {
           arms.PoisonBonus += SetBonus( equiping, bonus );
           arms.FireBonus += SetBonus( equiping, bonus );
           arms.Attributes.BonusMana += SetBonus( equiping, bonus );
           arms.Attributes.BonusHits += SetBonus( equiping, bonus );
           arms.Attributes.CastRecovery += SetBonus( equiping, bonus );
           arms.Attributes.ReflectPhysical += SetBonus( equiping, bonus );
           arms.Attributes.WeaponDamage += SetBonus( equiping, bonus );
           arms.Attributes.WeaponSpeed += SetBonus( equiping, bonus );
           arms.Attributes.AttackChance += SetBonus( equiping, bonus );
           arms.SkillBonuses.SetValues( 0, SkillName.Tactics, ( equiping ) ? bonus : 0.0 );
        }
        
        arms.Hue = (equiping) ? EqHue : 0x648;
        arms.PhysicalBonus += SetBonus( equiping, 10 );
        arms.ColdBonus += SetBonus( equiping, 10 );
		  arms.EnergyBonus += SetBonus( equiping, 5 );
        arms.ArmorAttributes.SelfRepair += SetBonus( equiping, 2 );
        arms.ArmorAttributes.MageArmor += SetBonus( equiping, 1 );
        
        arms.Attributes.BonusDex += SetBonus( equiping, 20 );
        arms.Attributes.Luck += SetBonus( equiping, 150 );
        arms.Attributes.LowerRegCost += SetBonus( equiping, 20 );
        arms.Attributes.CastSpeed += SetBonus( equiping, 4 );
        
        arms.InvalidateProperties();
        
        //LEGS
        if ( bonus > 0 )
        {
           legs.PoisonBonus += SetBonus( equiping, bonus );
           legs.FireBonus += SetBonus( equiping, bonus );
           legs.Attributes.BonusHits += SetBonus( equiping, bonus );
           legs.Attributes.BonusStam += SetBonus( equiping, bonus );
           legs.Attributes.RegenStam += SetBonus( equiping, bonus );
           legs.Attributes.ReflectPhysical += SetBonus( equiping, bonus );
           legs.Attributes.LowerRegCost += SetBonus( equiping, bonus );
           legs.Attributes.DefendChance += SetBonus( equiping, bonus );
           legs.Attributes.SpellDamage += SetBonus( equiping, bonus );
           legs.Attributes.WeaponDamage += SetBonus( equiping, bonus );
           legs.SkillBonuses.SetValues( 0, SkillName.Focus, ( equiping ) ? bonus : 0.0 );
        }
        
        legs.Hue = (equiping) ? EqHue : 0x648;
        legs.PhysicalBonus += SetBonus( equiping, 10 );
        legs.ColdBonus += SetBonus( equiping, 5 );
		  legs.EnergyBonus += SetBonus( equiping, 5 );
        legs.ArmorAttributes.SelfRepair += SetBonus( equiping, 2 );
        legs.ArmorAttributes.MageArmor += SetBonus( equiping, 1 );
        
        legs.Attributes.Luck += SetBonus( equiping, 150 );
        
        legs.InvalidateProperties();

        //CHEST
        if ( bonus > 0 )
        {
           chest.PhysicalBonus += SetBonus( equiping, bonus );
           chest.FireBonus += SetBonus( equiping, bonus );
           chest.Attributes.BonusMana += SetBonus( equiping, bonus );
           chest.Attributes.BonusHits += SetBonus( equiping, bonus );
           chest.Attributes.BonusStam += SetBonus( equiping, bonus );
           chest.Attributes.RegenHits += SetBonus( equiping, bonus );
           chest.Attributes.LowerRegCost += SetBonus( equiping, bonus );
           chest.Attributes.ReflectPhysical += SetBonus( equiping, bonus );
           chest.Attributes.WeaponDamage += SetBonus( equiping, bonus );
           chest.Attributes.EnhancePotions += SetBonus( equiping, bonus );
           chest.Attributes.AttackChance += SetBonus( equiping, bonus );
           chest.Attributes.SpellDamage += SetBonus( equiping, bonus );
           chest.SkillBonuses.SetValues( 0, SkillName.Anatomy, ( equiping ) ? bonus : 0.0 );
        }
        
        chest.Hue = (equiping) ? EqHue : 0x648;
        chest.ColdBonus += SetBonus( equiping, 5 );
		  chest.PoisonBonus += SetBonus( equiping, 5 );
		  chest.EnergyBonus += SetBonus( equiping, 10 );
        chest.ArmorAttributes.SelfRepair += SetBonus( equiping, 2 );
        chest.ArmorAttributes.MageArmor += SetBonus( equiping, 1 );
        
        chest.Attributes.Luck += SetBonus( equiping, 150 );
        chest.Attributes.LowerManaCost += SetBonus( equiping, 15 );
        chest.Attributes.DefendChance += SetBonus( equiping, 15 );
        chest.InvalidateProperties();
      }
      
      private static int SetBonus( bool equiping, int bonus )
      {
         return ( equiping ) ? bonus : -bonus;
      }
      
      public static void ChangeNameProperties( BaseArmor armor, ObjectPropertyList list )
      {
         list.Add( 1072376, "5" );
			
			if ( armor.Parent is Mobile )
			{
				if ( armor.Hue == 2546 )
				{
					list.Add( 1072377 );
					list.Add( "<basefont color=#FF9999>Bleed Immunity<basefont color=White>" );
				}
			}
      }
      
      public static void ChangeGetProperties( BaseArmor armor, ObjectPropertyList list )
      {
			if ( armor.Hue == 0x648 )
			{
				list.Add( 1072378 );
            list.Add( 1060437 );				
				list.Add( "Bleed Immunity\nSeveral other bonuses" );
			}
      }
      
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
			   list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
			   
			ChangeNameProperties( (BaseArmor) this, list );
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			ChangeGetProperties( (BaseArmor) this, list );
		}
      
		public override bool OnEquip( Mobile from )
		{
         IsFullSet( from, true, this, from.HandArmor, from.ArmsArmor, from.LegsArmor, from.ChestArmor );
         return base.OnEquip( from );
      }
      
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile from = ( Mobile ) parent;
				
            IsFullSet( from, false, this, from.HandArmor, from.ArmsArmor, from.LegsArmor, from.ChestArmor );
			}
			
			base.OnRemoved( parent );
		}

		public DaemonHelm( Serial serial ) : base( serial )
		{
		}
		
      public override void Serialize(GenericWriter writer)
      {
          base.Serialize(writer);

          writer.Write((int)1); // version
          writer.Write((int)m_Bonus);
      }

      public override void Deserialize(GenericReader reader)
      {
          base.Deserialize(reader);

          int version = reader.ReadInt();

          switch (version)
          {

              case 1:
                  {
                      m_Bonus = reader.ReadInt();
                      break;
                  }
          }
          
			if ( Weight == 1.0 )
				Weight = 3.0;

			if ( ArmorAttributes.SelfRepair == 0 )
				ArmorAttributes.SelfRepair = 1;
      }
	}
}