using System;
using Server.Items;

namespace Server.Items
{
	[FlipableAttribute( 0x13d5, 0x13dd )]
	public class RangerGloves : BaseArmor
	{
		private SkillMod m_SkillMod;
		
      public override int ArtifactRarity{ get{ return 16; } }
      
      public override int BasePhysicalResistance{ get{ return 8; } }
		public override int BaseFireResistance{ get{ return 8; } }
		public override int BaseColdResistance{ get{ return 7; } }
		public override int BasePoisonResistance{ get{ return 8; } }
		public override int BaseEnergyResistance{ get{ return 7; } }

		public override int InitMinHits{ get{ return 35; } }
		public override int InitMaxHits{ get{ return 45; } }

		public override int AosStrReq{ get{ return 25; } }
		public override int OldStrReq{ get{ return 25; } }

		public override int ArmorBase{ get{ return 16; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Studded; } }
		public override CraftResource DefaultResource{ get{ return CraftResource.RegularLeather; } }

		public override int LabelNumber{ get{ return 1041494; } } // studded gloves, ranger armor

		[Constructable]
		public RangerGloves() : base( 0x13D5 )
		{
			Weight = 1.0;
			Hue = 0x59C;
		}

		public RangerGloves( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			list.Add( 1060451, "{0}\t{1}", SkillName.Veterinary, "5" ); // ~1_skillname~ +~2_val~
		}
		
		public override void OnAdded( object parent )
		{
			base.OnAdded( parent );

			if ( parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Veterinary, true, 5 );
				m_SkillMod.ObeyCap = false;
				((Mobile)parent).AddSkillMod( m_SkillMod );
			}
		}

		public override void OnRemoved( object parent )
		{
			base.OnRemoved( parent );

			if ( m_SkillMod != null )
				m_SkillMod.Remove();

			m_SkillMod = null;
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
				
			if ( Parent is Mobile )
			{
				if ( m_SkillMod != null )
					m_SkillMod.Remove();

				m_SkillMod = new DefaultSkillMod( SkillName.Veterinary, true, 5 );
				m_SkillMod.ObeyCap = false;
				((Mobile)Parent).AddSkillMod( m_SkillMod );
			}
		}
	}
}