using System;
using Server;

namespace Server.Items
{
	public class DivineCountenance : HornedTribalMask
	{
		public override int LabelNumber{ get{ return 1061289; } } // Divine Countenance

		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public DivineCountenance()
		{
			Hue = 0x482;

			Attributes.BonusInt = 8;
			Attributes.RegenMana = 2;
			Attributes.LowerRegCost = 10;
			Attributes.LowerManaCost = 8;
		}

		public DivineCountenance( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
				{
					Resistances.Physical = 0;
					Resistances.Fire = 0;
					Resistances.Cold = 0;
					Resistances.Energy = 0;
					break;
				}
			}
		}
	}
}