using System;
using Server;

namespace Server.Items
{
	public class HatOfTheMagi : WizardsHat
	{
		public override int LabelNumber{ get{ return 1061597; } } // Hat of the Magi

		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public HatOfTheMagi()
		{
			Hue = 0x481;

			Attributes.BonusInt = 8;
			Attributes.RegenMana = 4;
			SkillBonuses.SetValues( 0, SkillName.Magery, 5 );
			SkillBonuses.SetValues( 1, SkillName.Meditation, 5 );
		}

		public HatOfTheMagi( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
				{
					Resistances.Poison = 0;
					Resistances.Energy = 0;
					break;
				}
			}
		}
	}
}