using System;
using Server.Network;
using Server.Prompts;

namespace Server.Items
{
	public abstract class BaseDecoSign : Item
	{
		public BaseDecoSign( int dispID ) : base( dispID )
		{
			Movable = true;
			Name = "Prazdna cedule";
			Weight = 1.0;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			else
			{
				from.SendMessage( "Jaky napis chces napsat na ceduli?" );
				from.Prompt = new RenamePrompt( (Item) this );
			}
		}

		private class RenamePrompt : Prompt
		{
			private Item m_Sign;

			public RenamePrompt( Item sign )
			{
				m_Sign = sign;
			}

			public override void OnResponse( Mobile from, string text )
			{
				if ( m_Sign != null && !m_Sign.Deleted )
				{
					m_Sign.Name = text;
					from.SendMessage( "Napis byl napsan na ceduli" );
				}
			}
		}

		public BaseDecoSign( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}