// Treasure Chest Pack - Version 0.99H
// By Nerun

using Server;
using Server.Items;
using Server.Network;
using System;

namespace Server.Items
{
	public abstract class BaseTreasureChestMod : LockableContainer
	{
      public static Type[] Artifacts = new Type[]
		{
			typeof( CookedFish ), typeof( CookedFish2 ), 
			typeof( Knitting ), typeof( LanternPost ),
			typeof( MetalPitcher ), typeof( MouldingBoard ),
			typeof( PileOfGarbage ), typeof( PegBoard ),
			typeof( PlateOfFood1 ), typeof( PlateOfFood2 ),
			typeof( PlateOfFood3 ), typeof( PlateOfFood4 ),
			typeof( DirtyPlate ), typeof( RawFish ),
			typeof( RawFish2 ), typeof( FishHead ),
			typeof( FishHeads ), typeof( RoseInVase ),
			typeof( Silverware ), typeof( SlicedHam ), typeof( SpendingPointsScroll ),
			typeof( SkullMug ), typeof( GreenBottle ), typeof( RedBottle ),
			typeof( SmallBrownBottle ), typeof( SmallGreenBottle ), typeof( SmallVioletBottle ),
			typeof( TinyYellowBottle ), typeof( SmallBlueFlask ), typeof( SmallYellowFlask ),
			typeof( SmallRedFlask ), typeof( SmallEmptyFlask ), typeof( YellowBeaker ),
			typeof( RedBeaker ), typeof( BlueBeaker ), typeof( GreenBeaker ),
			typeof( EmptyCurvedFlaskW ), typeof( RedCurvedFlask ), typeof( LtBlueCurvedFlask ),
			typeof( EmptyCurvedFlaskE ), typeof( BlueCurvedFlask ), typeof( GreenCurvedFlask ),
			typeof( RedRibbedFlask ), typeof( VioletRibbedFlask ), typeof( EmptyRibbedFlask ),
			typeof( LargeYellowFlask ), typeof( LargeVioletFlask ), typeof( LargeEmptyFlask ),
			typeof( SmallBlueBottle ), typeof( SmallGreenBottle2 ), typeof( EmptyJar ),
			typeof( FullJar ), typeof( HalfEmptyJar ), typeof( EmptyJars3 ),
			typeof( EmptyJars4 ), typeof( FullJars3 ), typeof( FullJars4 ),
			typeof( EmptyJars2 ), typeof( FullJars2 ), typeof( HalfEmptyJars2 ),
			typeof( EmptyVial ), typeof( HourglassAni ), typeof( TinyRedBottle ),
			typeof( PlayingCards ), typeof( PlayingCards2 ), typeof( PlayingCards3 ),
			typeof( PlayingCards4 ), typeof( PlayingCards5 ), typeof( ForgedMetal ),
			typeof( FruitBasket ), typeof( SlabOfBacon ), typeof( Beeswax ),
			typeof( IronWire ), typeof( SilverWire ), typeof( GoldWire ),
			typeof( CopperWire ), typeof( WhiteDriedFlowers ), typeof( GreenDriedFlowers ),
			typeof( DriedOnions ), typeof( DriedHerbs ), typeof( Whip ),
			typeof( PaintsAndBrush ), typeof( PenAndInk ), typeof( ChiselsNorth ),
			typeof( ChiselsWest ), typeof( DirtyPan ), typeof( DirtySmallRoundPot ),
			typeof( DirtyPot ), typeof( DirtyRoundPot ), typeof( DirtyFrypan ),
			typeof( DirtySmallPot ), typeof( DirtyKettle ), typeof( MagicCrystalBall )
		};
      
      private ChestTimer m_DeleteTimer;
		//public override bool Decays { get{ return true; } }
		//public override TimeSpan DecayTime{ get{ return TimeSpan.FromMinutes( Utility.Random( 10, 15 ) ); } }
		public override int DefaultGumpID{ get{ return 0x42; } }
		public override int DefaultDropSound{ get{ return 0x42; } }
		public override Rectangle2D Bounds{ get{ return new Rectangle2D( 20, 105, 150, 180 ); } }
		public override bool IsDecoContainer{get{ return false; }}
		
		public BaseTreasureChestMod( int itemID ) : base ( itemID )
		{
			Locked = true;
			Movable = false;

			Key key = (Key)FindItemByType( typeof(Key) );

			if( key != null )
				key.Delete();
		}

		public BaseTreasureChestMod( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if( !Locked )
				StartDeleteTimer();
		}

		public override void OnTelekinesis( Mobile from )
		{
			if ( CheckLocked( from ) )
			{
				Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x376A, 9, 32, 5022 );
				Effects.PlaySound( Location, Map, 0x1F5 );
				return;
			}

			base.OnTelekinesis( from );
			Name = "a treasure chest";
			StartDeleteTimer();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( CheckLocked( from ) )
				return;

			base.OnDoubleClick( from );
			Name = "a treasure chest";
			
			if ( from.AccessLevel == AccessLevel.Player )
			   StartDeleteTimer();
		}

		private void StartDeleteTimer()
		{
			if( m_DeleteTimer == null )
				m_DeleteTimer = new ChestTimer( this );
			else
				m_DeleteTimer.Delay = TimeSpan.FromSeconds( Utility.Random( 1, 2 ));
				
			m_DeleteTimer.Start();
		}

		private class ChestTimer : Timer
		{
			private BaseTreasureChestMod m_Chest;
			
			public ChestTimer( BaseTreasureChestMod chest ) : base ( TimeSpan.FromMinutes( Utility.Random( 2, 5 ) ) )
			{
				m_Chest = chest;
				Priority = TimerPriority.OneMinute;
			}

			protected override void OnTick()
			{
				m_Chest.Delete();
			}
		}
	}
}