// Treasure Chest Pack - Version 0.99H
// By Nerun

using Server;
using Server.Items;
using Server.Multis;
using Server.Network;
using System;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{

	// ---------- [Level 1] ----------
	// Large, Medium and Small Crate
	[FlipableAttribute( 0xe3e, 0xe3f )]
	public class TreasureLevel1 : BaseTreasureChestMod
	{
		public override int DefaultGumpID{ get{ return 0x49; } }

		[Constructable]
		public TreasureLevel1() : base( Utility.RandomList( 0xE3C, 0xE3E, 0x9a9 ) )
		{
			RequiredSkill = 52;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 1 * Utility.Random( 1, 25 );
			DropItem( new Gold( 30, 100 ) );
			DropItem( Loot.RandomWeapon() );
			DropItem( Loot.RandomArmorOrShield() );
			DropItem( Loot.RandomClothing() );
			DropItem( Loot.RandomJewelry() );
			DropItem( new Bolt( 10 ) );
			for( int i = 1; i > 1; i-- )
			{
				Item GemLoot = Loot.RandomGem();
				GemLoot.Amount = Utility.Random( 1, 3 );
				DropItem( GemLoot );
			}
			//runic tool
			if (Utility.RandomDouble() < 0.003)
			{
				if ( Utility.RandomBool() )
					DropItem( Loot.RandomRunicTool() );
				else
					DropItem( new RandomTalisman() );
			}
			//Treasure map piece
			if (Utility.RandomDouble() < 0.0013)
			{
				DropItem( new TreasureMapPiece() );
			}
			//ParchmentMessage
			if (Utility.RandomDouble() < 0.001)
			{
				if ( Utility.RandomBool() )
				{
					Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
					DropItem( item );
				}
				else
					DropItem( new ParchmentMessage( (Utility.RandomDouble() < 0.75)? Map.Trammel : Map.Felucca, 4) );
			}
		}

		public TreasureLevel1( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	// ---------- [Level 1h] ----------
	// Large, Medium and Small Crate
	[FlipableAttribute( 0xe3e, 0xe3f )]
	public class TreasureLevel1h : BaseTreasureChestMod
	{
		public override int DefaultGumpID{ get{ return 0x49; } }

		[Constructable]
		public TreasureLevel1h() : base( Utility.RandomList( 0xE3C, 0xE3E, 0x9a9 ) )
		{
			RequiredSkill = 56;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 1 * Utility.Random( 1, 25 );
			DropItem( new Gold( 10, 40 ) );
			DropItem( new Bolt( 15 ) );
			switch ( Utility.Random( 6 ))
			{
					case 0: DropItem( new Candelabra()  ); break;
					case 1: DropItem( new Candle() ); break;
					case 2: DropItem( new CandleLarge() ); break;
					case 3: DropItem( new CandleLong() ); break;
					case 4: DropItem( new CandleShort() ); break;
					case 5: DropItem( new CandleSkull() ); break;
			}
			switch ( Utility.Random( 2 ))
			{
					case 0: DropItem( new Shoes( Utility.Random( 1, 2 ) ) ); break;
					case 1: DropItem( new Sandals( Utility.Random( 1, 2 ) ) ); break;
			}

			switch ( Utility.Random( 3 ))
			{
					case 0: DropItem( new BeverageBottle(BeverageType.Ale) ); break;
					case 1: DropItem( new BeverageBottle(BeverageType.Liquor) ); break;
					case 2: DropItem( new Jug(BeverageType.Cider) ); break;
			}
			//runic tool
			if (Utility.RandomDouble() < 0.003)
			{
				if ( Utility.RandomBool() )
					DropItem( Loot.RandomRunicTool() );
				else
					DropItem( new RandomTalisman() );
			}
			//Treasure map piece
			if (Utility.RandomDouble() < 0.001)
			{
				DropItem( new TreasureMapPiece() );
			}
			//ParchmentMessage
			if (Utility.RandomDouble() < 0.003)
			{
				if ( Utility.RandomBool() )
				{
					Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
					DropItem( item );
				}
				else
					DropItem( new ParchmentMessage( (Utility.RandomDouble() < 0.75)? Map.Trammel : Map.Felucca, 4) );
			}
		}

		public TreasureLevel1h( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	// ---------- [Level 2] ----------
	// Large, Medium and Small Crate
	// Wooden, Metal and Metal Golden Chest
	// Keg and Barrel
	[FlipableAttribute( 0xe43, 0xe42 )]
	public class TreasureLevel2 : BaseTreasureChestMod
	{
		[Constructable]
		public TreasureLevel2() : base( Utility.RandomList( 0xe3c, 0xE3E, 0x9a9, 0xe42, 0x9ab, 0xe40, 0xe7f, 0xe77 ) )
		{
			RequiredSkill = 72;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 2 * Utility.Random( 10, 25 );
			DropItem( new Gold( 70, 100 ) );
			DropItem( new Arrow( Utility.Random( 5, 20 ) ) );
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
			{
				Item ReagentLoot = Loot.RandomReagent();
				ReagentLoot.Amount = Utility.Random( 5, 10 );
				DropItem( ReagentLoot );
			}
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
			{
				Item ScrollLoot = Loot.RandomScroll( 0, 39, SpellbookType.Regular );
				ScrollLoot.Amount = Utility.Random( 1, 8 );
				DropItem( ScrollLoot );
			}
			DropItem( Loot.RandomPotion() );
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
			{
				Item GemLoot = Loot.RandomGem();
				GemLoot.Amount = Utility.Random( 1, 5 );
				DropItem( GemLoot );
			}
			//runic tool
			if (Utility.RandomDouble() < 0.003)
			{
				if ( Utility.RandomBool() )
					DropItem( Loot.RandomRunicTool() );
				else
					DropItem( new RandomTalisman() );
			}
			//Treasure map piece
			if (Utility.RandomDouble() < 0.002)
			{
				DropItem( new TreasureMapPiece() );
			}
			//ParchmentMessage
			if (Utility.RandomDouble() < 0.002)
			{
				if ( Utility.RandomBool() )
				{
					Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
					DropItem( item );
				}
				else
					DropItem( new ParchmentMessage( (Utility.RandomDouble() < 0.75)? Map.Trammel : Map.Felucca, 4) );
			}
		}

		public TreasureLevel2( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	// ---------- [Level 3] ----------
	// Wooden, Metal and Metal Golden Chest
	[FlipableAttribute( 0x9ab, 0xe7c )]
	public class TreasureLevel3 : BaseTreasureChestMod
	{
		public override int DefaultGumpID{ get{ return 0x4A; } }

		[Constructable]
		public TreasureLevel3() : base( Utility.RandomList( 0x9ab, 0xe40, 0xe42 ) )
		{
			RequiredSkill = 84;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 3 * Utility.Random( 10, 25 );
			DropItem( new Gold( 180, 250 ) );
			DropItem( new Arrow( Utility.Random( 5, 30 ) ) );
			for( int i = Utility.Random( 1, 4 ); i > 1; i-- )
			{
				Item ReagentLoot = Loot.RandomReagent();
				ReagentLoot.Amount = Utility.Random( 10, 19 );
				DropItem( ReagentLoot );
			}
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item ScrollLoot = Loot.RandomScroll( 0, 47, SpellbookType.Regular );
				ScrollLoot.Amount = Utility.Random( 1, 12 );
				DropItem( ScrollLoot );
			}
			for ( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item PotionLoot = Loot.RandomPotion();
				DropItem( PotionLoot );
			}
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item GemLoot = Loot.RandomGem();
				GemLoot.Amount = Utility.Random( 3, 7 );
				DropItem( GemLoot );
			}
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
				DropItem( Loot.RandomWand() );
			// Magical ArmorOrWeapon
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item item = Loot.RandomArmorOrShieldOrWeapon();

				if( item is BaseWeapon )
				{
					BaseWeapon weapon = (BaseWeapon)item;
					weapon.DamageLevel = (WeaponDamageLevel)Utility.Random( 5 );
					weapon.AccuracyLevel = (WeaponAccuracyLevel)Utility.Random( 5 );
					weapon.DurabilityLevel = (WeaponDurabilityLevel)Utility.Random( 5 );
					weapon.Quality = WeaponQuality.Regular;
				}
				else if( item is BaseArmor )
				{
					BaseArmor armor = (BaseArmor)item;
					armor.ProtectionLevel = (ArmorProtectionLevel)Utility.Random( 5 );
					armor.Durability = (ArmorDurabilityLevel)Utility.Random( 5 );
					armor.Quality = ArmorQuality.Regular;
				}

				DropItem( item );
			}
			// End
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
				DropItem( Loot.RandomClothing() );
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
				DropItem( Loot.RandomJewelry() );
			//runic tool
			if (Utility.RandomDouble() < 0.005)
			{
				if ( Utility.RandomBool() )
					DropItem( Loot.RandomRunicTool() );
				else
					DropItem( new RandomTalisman() );
			}
			//level item
			if (Utility.RandomDouble() < 0.001)
			{
				Container bag = new Bag();
				bag.DropItem( Loot.RandomLevelItem( ( Map == Map.Tokuno )?true:false ) );
				bag.Hue = 100;
				DropItem( bag );
			}
			//dye tub
			if (Utility.RandomDouble() < 0.002)
			{
				int TheHue = Utility.RandomMinMax( 1150, 1189);
				DyeTub dt = new AllDyeTubsAll();
				dt.DyedHue = TheHue;
				dt.Hue = TheHue;
				DropItem( dt );
			}
			//Treasure map piece
			if (Utility.RandomDouble() < 0.002)
			{
				DropItem( new TreasureMapPieceRare() );
			}
			//ParchmentMessage
			if (Utility.RandomDouble() < 0.003)
			{
				if ( Utility.RandomBool() )
				{
					Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
					DropItem( item );
				}
				else
					DropItem( new ParchmentMessage( (Utility.RandomDouble() < 0.75)? Map.Trammel : Map.Felucca, 4) );
			}

			// Magic clothing (not implemented)
			// Magic jewelry (not implemented)
		}

		public TreasureLevel3( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	// ---------- [Level 4] ----------
	// Wooden, Metal and Metal Golden Chest
	[FlipableAttribute( 0xe41, 0xe40 )]
	public class TreasureLevel4 : BaseTreasureChestMod
	{
		[Constructable]
		public TreasureLevel4() : base( Utility.RandomList( 0xe40, 0xe42, 0x9ab ) )
		{
			RequiredSkill = 92;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 4 * Utility.Random( 15, 25 );
			DropItem( new Gold( 200, 400 ) );
			for( int i = Utility.Random( 1, 4 ); i > 1; i-- )
			{
				Item ReagentLoot = Loot.RandomReagent();
				ReagentLoot.Amount = Utility.Random( 6, 22 );
				DropItem( ReagentLoot );
			}
			for( int i = Utility.Random( 1, 4 ); i > 1; i-- )
			{
				Item ScrollLoot = Loot.RandomScroll( 0, 47, SpellbookType.Regular );
				ScrollLoot.Amount = Utility.Random( 5, 15 );
				DropItem( ScrollLoot );
			}
			DropItem( new BlankScroll( Utility.Random( 1, 24 ) ) );
			for ( int i = Utility.Random( 1, 4 ); i > 1; i-- )
			{
				Item PotionLoot = Loot.RandomPotion();
				DropItem( PotionLoot );
			}
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item GemLoot = Loot.RandomGem();
				GemLoot.Amount = Utility.Random( 5, 10 );
				DropItem( GemLoot );
			}
			for( int i = Utility.Random( 1, 4 ); i > 1; i-- )
				DropItem( Loot.RandomWand() );

			// Magical ArmorOrWeapon
			for( int i = Utility.Random( 1, 4 ); i > 1; i-- )
			{
				Item item = Loot.RandomArmorOrShieldOrWeapon();

				if( item is BaseWeapon )
				{
					BaseWeapon weapon = (BaseWeapon)item;
					weapon.DamageLevel = (WeaponDamageLevel)Utility.Random( 6 );
					weapon.AccuracyLevel = (WeaponAccuracyLevel)Utility.Random( 6 );
					weapon.DurabilityLevel = (WeaponDurabilityLevel)Utility.Random( 6 );
					weapon.Quality = WeaponQuality.Regular;
				}
				else if( item is BaseArmor )
				{
					BaseArmor armor = (BaseArmor)item;
					armor.ProtectionLevel = (ArmorProtectionLevel)Utility.Random( 6 );
					armor.Durability = (ArmorDurabilityLevel)Utility.Random( 6 );
					armor.Quality = ArmorQuality.Regular;
				}

				DropItem( item );
			}
			// End
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
				DropItem( Loot.RandomClothing() );
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
				DropItem( Loot.RandomJewelry() );
			
			//runic tool / talisman
			if (Utility.RandomDouble() < 0.075)
			{
				if ( Utility.RandomBool() )
					DropItem( Loot.RandomRunicTool() );
				else
					DropItem( new RandomTalisman() );
			}			
			//mesicni kamen/ magical wire
			if (Utility.RandomDouble() < 0.01)
			{
				if ( Utility.RandomBool() )
					DropItem( new MesicniKamen() );
				else
					DropItem( new MagicalWire() );
			}			
			//level item
			if (Utility.RandomDouble() < 0.02)
			{
				Container bag = new Bag();
				bag.DropItem( Loot.RandomLevelItem( ( Map == Map.Tokuno )?true:false ) );
				bag.Hue = 100;
				DropItem( bag );
			}
			//dye tub
			if (Utility.RandomDouble() < 0.03)
			{
				int TheHue = Utility.RandomMinMax( 1150, 1177);
				DyeTub dt = new AllDyeTubsAll();
				dt.DyedHue = TheHue;
				dt.Hue = TheHue;
				DropItem( dt );
			}
			//Treasure map piece
			if (Utility.RandomDouble() < 0.01)
			{
				DropItem( new TreasureMapPieceAncient() );
			}
			//deco artik, scroll
			if (Utility.RandomDouble() < 0.08)
			{
            Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
				DropItem( item );
			}
			//magic scroll
			if (Utility.RandomDouble() < 0.01)
			{
            DropItem( new MagicScroll() );
			}
			// Magic clothing (not implemented)
			// Magic jewelry (not implemented)
		}

		public TreasureLevel4( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	// ---------- [Level UW] ----------
	// Wooden, Metal and Metal Golden Chest
	[FlipableAttribute( 0xe41, 0xe40 )]
	public class TreasureChestUW : BaseTreasureChestMod
	{
		[Constructable]
		public TreasureChestUW() : base( Utility.RandomList( 0xe40, 0xe42, 0x9ab ) )
		{
			RequiredSkill = 50;
			LockLevel = this.RequiredSkill - Utility.Random( 1, 10 );
			MaxLockLevel = this.RequiredSkill;
			TrapType = TrapType.MagicTrap;
			TrapPower = 4 * Utility.Random( 15, 25 );
			
			DropItem( new Gold( 6, 20 ) );
			
			for( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item ReagentLoot = Loot.RandomReagent();
				ReagentLoot.Amount = Utility.Random( 6, 30 );
				DropItem( ReagentLoot );
			}
			
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
			{
				Item ScrollLoot = Loot.RandomScroll( 0, 47, SpellbookType.Regular );
				ScrollLoot.Amount = Utility.Random( 1, 2 );
				DropItem( ScrollLoot );
			}
			
			DropItem( new BlankScroll( Utility.Random( 1, 8 ) ) );
			
			for ( int i = Utility.Random( 1, 3 ); i > 1; i-- )
			{
				Item PotionLoot = Loot.RandomPotion();
				DropItem( PotionLoot );
			}
			
			for( int i = Utility.Random( 1, 2 ); i > 1; i-- )
			{
				Item GemLoot = Loot.RandomGem();
				GemLoot.Amount = Utility.Random( 1, 2 );
				DropItem( GemLoot );
			}

			DropItem( Loot.RandomClothing() );
			
			if ( Utility.RandomDouble() < 0.05 )
			{
				Item item = Loot.RandomArmorOrShieldOrWeapon();

				if( item is BaseWeapon )
				{
					BaseWeapon weapon = (BaseWeapon)item;
					weapon.DamageLevel = (WeaponDamageLevel)Utility.Random( 2 );
					weapon.AccuracyLevel = (WeaponAccuracyLevel)Utility.Random( 2 );
					weapon.DurabilityLevel = (WeaponDurabilityLevel)Utility.Random( 3 );
					weapon.Quality = WeaponQuality.Regular;
					weapon.IsUWItem = true;
				}
				else if( item is BaseArmor )
				{
					BaseArmor armor = (BaseArmor)item;
					armor.ProtectionLevel = (ArmorProtectionLevel)Utility.Random( 2 );
					armor.Durability = (ArmorDurabilityLevel)Utility.Random( 3 );
					armor.Quality = ArmorQuality.Regular;
					armor.IsUWItem = true;
				}

				DropItem( item );
			}

			//dye tub
			if (Utility.RandomDouble() < 0.03)
			{
				int TheHue = Utility.RandomMinMax( 1150, 1177);
				DyeTub dt = new AllDyeTubsAll();
				dt.DyedHue = TheHue;
				dt.Hue = TheHue;
				DropItem( dt );
			}
		}

		public TreasureChestUW( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
