using System;
using System.Collections;
using System.Collections.Generic;
using Server.Network;

namespace Server.Items
{
    public class TreasureMapChestBag : Bag
    {
        private LockableContainer m_TChest;

        // 		[CommandProperty( AccessLevel.GameMaster )]
        public LockableContainer TChest { get { return m_TChest; } set { m_TChest = value; } }

        [Constructable]
        public TreasureMapChestBag(LockableContainer tchest)
        {
            m_TChest = tchest;
            Movable = false;
        }

        public override void OnItemLifted(Mobile from, Item item)
        {
            if (m_TChest != null && m_TChest is TreasureMapChest)
            {
                TreasureMapChest chest = m_TChest as TreasureMapChest;
                bool notYetLifted = !chest.m_Lifted.Contains(item);

                from.RevealingAction();

                if (notYetLifted)
                {
                    chest.m_Lifted.Add(item);

                    if (0.1 >= Utility.RandomDouble() && from.AccessLevel < AccessLevel.GameMaster) // 10% chance to spawn a new monster
                        TreasureMap.Spawn(chest.Level, chest.GetWorldLocation(), chest.Map, from, false, chest );
                }
            }

            base.OnItemLifted(from, item);
        }

        public TreasureMapChestBag(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write(m_TChest);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            m_TChest = reader.ReadItem() as LockableContainer;
        }
    }
}