using System;
using Server.Mobiles;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;

namespace Server.Items
{
	public class HairRestylingDeed : Item
	{
		public override int LabelNumber{ get{ return 1041061; } } // a coupon for a free hair restyling

		[Constructable]
		public HairRestylingDeed() : base( 0x14F0 )
		{
			Weight = 1.0;
			LootType = LootType.Blessed;
		}

		public HairRestylingDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			else
				from.SendGump( new InternalGump( from, this ) );
		}

		private class InternalGump : Gump
		{
			private Mobile m_From;
			private HairRestylingDeed m_Deed;

			public InternalGump( Mobile from, HairRestylingDeed deed ) : base( 50, 50 )
			{
				m_From = from;
				m_Deed = deed;

				from.CloseGump( typeof( InternalGump ) );

			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(4, 7, 620, 535, 5170);
			this.AddImageTiled(140, 40, 42, 42, 87);
			this.AddImageTiled(140, 160, 42, 42, 87);
			this.AddImageTiled(140, 220, 42, 42, 87);
			this.AddImageTiled(140, 280, 42, 42, 87);
			this.AddImageTiled(140, 340, 42, 42, 87);
			this.AddImageTiled(140, 400, 42, 42, 87);
			this.AddImageTiled(140, 460, 42, 42, 87);
			this.AddImageTiled(140, 100, 42, 42, 87);
			this.AddImageTiled(340, 40, 42, 42, 87);
			this.AddImageTiled(340, 160, 42, 42, 87);
			this.AddImageTiled(340, 220, 42, 42, 87);
			this.AddImageTiled(340, 280, 42, 42, 87);
			this.AddImageTiled(340, 340, 42, 42, 87);
			this.AddImageTiled(340, 400, 42, 42, 87);
			this.AddImageTiled(340, 460, 42, 42, 87);
			this.AddImageTiled(340, 100, 42, 42, 87);
			this.AddImageTiled(541, 280, 42, 42, 87);
			this.AddLabel(40, 53, 1152, @"Short");
			this.AddLabel(40, 113, 1152, @"Long");
			this.AddLabel(40, 173, 1152, @"Ponytail");
			this.AddLabel(40, 233, 1152, @"Mohawk");
			this.AddLabel(40, 293, 1152, @"Pageboy");
			this.AddLabel(40, 353, 1152, @"Receeding");
			this.AddLabel(40, 413, 1152, @"2-Tails");
			this.AddLabel(40, 473, 1152, @"Topknot");
			this.AddLabel(402, 172, 1152, @"Mid Long Hair");
			this.AddImageTiled(540, 160, 42, 42, 87);
			this.AddLabel(198, 54, 1152, @"Afro");
			this.AddLabel(198, 115, 1152, @"Feather Hair");
			this.AddLabel(198, 173, 1152, @"Short Hair");
			this.AddLabel(198, 233, 1152, @"Mullet");
			this.AddLabel(198, 290, 1152, @"Flower");
			this.AddLabel(198, 352, 1152, @"Elven Long Hair");
			this.AddLabel(198, 414, 1152, @"Long Big Knob");
			this.AddLabel(198, 472, 1152, @"Long Big Braid");
			this.AddImageTiled(540, 40, 42, 42, 87);
			this.AddImageTiled(540, 100, 42, 42, 87);
			this.AddLabel(402, 52, 1152, @"Long Big Buns");
			this.AddLabel(402, 112, 1152, @"Spiked");
// 			this.AddLabel(402, 232, 1152, @"Spiked");
			this.AddLabel(401, 294, 1152, @"Bald");
			this.AddLabel(498, 517, 0, @"RMB To close");
			this.AddImage(48, -20, 1875);
			this.AddImage(48, 31, 1842);
			this.AddImage(49, 95, 1879);
			this.AddImage(49, 157, 1843);
			this.AddImage(49, 218, 1871);
			this.AddImage(49, 279, 1878);
			this.AddImage(47, 332, 1836);
			this.AddImage(52, 396, 1840);
			this.AddImage(249, -22, 1839);
			this.AddImage(252, 36, 1775);
			this.AddImage(249, 100, 1786);
			this.AddImage(249, 157, 1787);
			this.AddImage(250, 213, 1778);
			this.AddImage(248, 276, 1792);
			this.AddImage(250, 336, 1780);
			this.AddImage(251, 392, 1781);
			this.AddImage(449, -24, 1782);
			this.AddImage(450, 37, 1783);
			this.AddImage(449, 96, 1784);
			this.AddLabel(473, 388, 1152, @"Hairs can look a little");
			this.AddLabel(472, 410, 1152, @"bit different because");
			this.AddLabel(492, 432, 1152, @"Males and Females");
			this.AddLabel(475, 453, 1152, @"Cant have same hairs");
			this.AddLabel(487, 474, 1152, @"it will make graphic");
			this.AddLabel(545, 496, 1152, @"problems.");
			this.AddButton(107, 52, 1155, 1153, 1, GumpButtonType.Reply, 0 ); //Short
			this.AddButton(107, 113, 1155, 1153, 2, GumpButtonType.Reply, 0 ); //Long
			this.AddButton(107, 172, 1155, 1153, 3, GumpButtonType.Reply, 0 ); //Pony
			this.AddButton(107, 232, 1155, 1153, 4, GumpButtonType.Reply, 0 ); //Mohawk
			this.AddButton(107, 292, 1155, 1153, 5, GumpButtonType.Reply, 0 ); //Pageboy
			this.AddButton(107, 352, 1155, 1153, 6, GumpButtonType.Reply, 0 ); //Receeding
			this.AddButton(107, 412, 1155, 1153, 7, GumpButtonType.Reply, 0 );  //2-Tails
			this.AddButton(107, 472, 1155, 1153, 8, GumpButtonType.Reply, 0 ); //Topknot
			this.AddButton(307, 52, 1155, 1153, 9, GumpButtonType.Reply, 0 ); //Afro
			this.AddButton(307, 113, 1155, 1153, 10, GumpButtonType.Reply, 0 ); //Feather
			this.AddButton(307, 172, 1155, 1153, 11, GumpButtonType.Reply, 0 ); //Short
			this.AddButton(307, 231, 1155, 1153, 12, GumpButtonType.Reply, 0 ); //Mullet
			this.AddButton(307, 291, 1155, 1153, 13, GumpButtonType.Reply, 0 ); //Flower
			this.AddButton(307, 351, 1155, 1153, 14, GumpButtonType.Reply, 0 ); //Long2
			this.AddButton(307, 411, 1155, 1153, 15, GumpButtonType.Reply, 0 ); //Knob
			this.AddButton(307, 471, 1155, 1153, 16, GumpButtonType.Reply, 0 ); //Braid
			this.AddButton(507, 52, 1155, 1153, 17, GumpButtonType.Reply, 0 ); //Buns
			this.AddButton(507, 113, 1155, 1153, 18, GumpButtonType.Reply, 0 ); //Spiked
			this.AddButton(507, 172, 1155, 1153, 19, GumpButtonType.Reply, 0 ); //MidLong
			this.AddButton(507, 291, 1155, 1153, 25, GumpButtonType.Reply, 0 ); //Bald
			this.AddLabel(241, 10, 1153, @"HAIR-RESTYLING MENU");
			}

			public override void OnResponse( NetState sender, RelayInfo info )
			{
				if ( m_Deed.Deleted )
					return;

				int newHair = 0;

				switch ( info.ButtonID )
				{
					case 0: break;
					case 1:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x203B;//short
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 2:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x203C;// LongHair
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 3:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x203D;// PonyTail
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 4:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x2044;// Mohawk
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 5:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x2045;// PageboyHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 6:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x2048;// ReceedingHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 7:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x2049;// TwoPigTails();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 8:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x204A;// KrisnaHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 9:
               {
                  if ( m_From.Race == Race.Human )
                     newHair = 0x2047;// Afro();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze clovek");
                     return;
                  }
               }
               break;
					case 10:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FC0;// LongFeatherHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 11:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FC1;// ShortElfHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 12:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FC2;// Mullet();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 13:
               {
                  if ( m_From.Race == Race.Elf && m_From.Female )
                     newHair = 0x2FCC;// FlowerHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elfi zena");
                     return;
                  }
               }
               break;
					case 14:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FCD;// LongElfHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 15:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FCE;// LongBigKnobHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 16:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FCF;// LongBigBraidHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 17:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FD0;// LongBigBunHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 18:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FD1;// SpikedHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 19:
               {
                  if ( m_From.Race == Race.Elf )
                     newHair = 0x2FBF;// MidLongHair();
                  else
                  {
                     m_From.SendMessage("Tento uces muze mit pouze elf");
                     return;
                  }
               }
               break;
					case 25:
               {
      				if ( m_From is PlayerMobile )
      				  ((PlayerMobile)m_From).SetHairMods( -1, -1 ); // clear any hairmods (disguise kit, incognito)
      				  
                  m_From.HairItemID = 0;
                     
                  m_Deed.Delete();
                  return;
               }
               break;
				}

				if ( info.ButtonID > 0 )
				{
    				if ( newHair > 0 )
    				{
      				if ( m_From is PlayerMobile )
      				  ((PlayerMobile)m_From).SetHairMods( -1, -1 ); // clear any hairmods (disguise kit, incognito)
                   
                  m_From.HairItemID = newHair;
                   
    					m_Deed.Delete();
    				}
            }
			}
		}
	}
}