using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class BaseMagicalFood : Food
	{
		[Constructable]
		public BaseMagicalFood( int itemID ) : base( itemID )
		{
			Weight = 1.0;
			FillFactor = 0;
			Stackable = true;
		}
	
		public BaseMagicalFood( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}