using System;
using Server;
using Server.Mobiles;
using Server.Spells;

namespace Server.Items
{
	public class KulickyCesnek : BaseMagicalFood
	{
		[Constructable]
		public KulickyCesnek() : base( 3699 )
		{
			Name = "Cesnekove Kulicky";
			Hue = 1577;
		}
	
		public KulickyCesnek( Serial serial ) : base( serial )
		{
		}
		
		public override bool Eat( Mobile from )
		{
			if ( from.MeleeDamageAbsorb > 0 )
			{
				from.SendLocalizedMessage( 1005559 ); // This spell is already in effect.
				return false;
			}
			
         if ( from.BeginAction( typeof( KulickyCesnek ) ) )
			{
				from.RevealingAction();
            
            from.MeleeDamageAbsorb = from.HitsMax;

				from.FixedParticles( 0x376A, 9, 32, 5008, EffectLayer.Waist );
				from.PlaySound( 489 );
				from.SendMessage( "Cesnekova chut teto kulicky ti udelila ochranu pred fyzickym utokem" );
				
				Timer.DelayCall( TimeSpan.FromMinutes( 3.0 ), new TimerStateCallback( ReleaseKulickyCesnekLock ), from );
				Consume();
				return true;
			}
			else
				from.SendLocalizedMessage( 1070772 ); // You must wait a few seconds before you can use that item.
				
			return false;
		}
		
		private static void ReleaseKulickyCesnekLock( object state )
		{
			((Mobile)state).EndAction( typeof( KulickyCesnek ) );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}