using System;
using Server;
using Server.Mobiles;
using Server.Spells;
using Server.Spells.Spellweaving;

namespace Server.Items
{
	public class KulickyPikant : BaseMagicalFood
	{
		[Constructable]
		public KulickyPikant() : base( 3699 )
		{
			Name = "Pikantni Kulicky";
			Hue = 1794;
		}
	
		public KulickyPikant( Serial serial ) : base( serial )
		{
		}
		
		public override bool Eat( Mobile from )
		{
			if ( from.MagicDamageAbsorb > 0 || AttunementSpell.IsAbsorbing( from ) )
			{
				from.SendLocalizedMessage( 1005559 ); // This spell is already in effect.
				return false;
			}
			
         if ( from.BeginAction( typeof( KulickyPikant ) ) )
			{
				
				from.RevealingAction();
				
            int absorb = from.RawInt / 6;
						
				if ( absorb > 20 )
					absorb = 20;
				else if ( absorb < 1 )
					absorb = 1;
						   
            from.MagicDamageAbsorb = absorb;

				from.FixedParticles( 0x375A, 10, 15, 5037, EffectLayer.Waist );
				from.PlaySound( 0x1E9 );
				from.SendMessage( "Pikantni chut teto kulicky ti udelila ochranu pred kouzly" );
				
				Timer.DelayCall( TimeSpan.FromMinutes( 3.0 ), new TimerStateCallback( ReleaseKulickyPikantLock ), from );
				Consume();
				return true;
			}
			else
				from.SendLocalizedMessage( 1070772 ); // You must wait a few seconds before you can use that item.
				
			return false;
		}
		
		private static void ReleaseKulickyPikantLock( object state )
		{
			((Mobile)state).EndAction( typeof( KulickyPikant ) );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}