using System;
using Server;
using Server.Spells;
using Server.Spells.Necromancy;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class Medovina : BaseMagicalFood
	{
		[Constructable]
		public Medovina() : base( 0x9ec )
		{
			Name = "leciva medovina";
			Hue = 44;
		}
	
		public Medovina( Serial serial ) : base( serial )
		{
		}
		
		public override bool Eat( Mobile from )
		{
			if ( from.BeginAction( typeof( Medovina ) ) )
			{
				from.PlaySound( 0xF6 );
				from.PlaySound( 0x1F7 );
				from.FixedParticles( 0x3709, 1, 30, 9963, 13, 3, EffectLayer.Head );

				IEntity mfrom = new Entity( Serial.Zero, new Point3D( from.X, from.Y, from.Z - 10 ), from.Map );
				IEntity mto = new Entity( Serial.Zero, new Point3D( from.X, from.Y, from.Z + 50 ), from.Map );
				Effects.SendMovingParticles( mfrom, mto, 0x2255, 1, 0, false, false, 13, 3, 9501, 1, 0, EffectLayer.Head, 0x100 );

				StatMod mod;

				mod = from.GetStatMod( "[Magic] Str Offset" );
				if ( mod != null && mod.Offset < 0 )
					from.RemoveStatMod( "[Magic] Str Offset" );

				mod = from.GetStatMod( "[Magic] Dex Offset" );
				if ( mod != null && mod.Offset < 0 )
					from.RemoveStatMod( "[Magic] Dex Offset" );

				mod = from.GetStatMod( "[Magic] Int Offset" );
				if ( mod != null && mod.Offset < 0 )
					from.RemoveStatMod( "[Magic] Int Offset" );

				from.Paralyzed = false;
				from.Poison = null;

				EvilOmenSpell.CheckEffect( from );
				StrangleSpell.RemoveCurse( from );
				CorpseSkinSpell.RemoveCurse( from );
				CurseSpell.RemoveEffect( from );				
				BleedAttack.EndBleed( from, false );
				MortalStrike.EndWound( from );
						
				BuffInfo.RemoveBuff( from, BuffIcon.Bleed );
				BuffInfo.RemoveBuff( from, BuffIcon.MortalStrike );
				BuffInfo.RemoveBuff( from, BuffIcon.Clumsy );
				BuffInfo.RemoveBuff( from, BuffIcon.FeebleMind );
				BuffInfo.RemoveBuff( from, BuffIcon.Weaken );
				BuffInfo.RemoveBuff( from, BuffIcon.MassCurse );
				
				Timer.DelayCall( TimeSpan.FromSeconds( 60.0 ), new TimerStateCallback( ReleaseMedovinaLock ), from );
				Consume();
				
  				ExpireTimer t = new ExpireTimer( from, TimeSpan.FromSeconds( 59.0 ) );
  				t.Start();
  				m_Table[from] = t;
  					
				from.SendMessage( "Vypiti hrnku lecive medoviny odstranilo vsechny kletby" );
  				from.SendMessage( "Na 1 minutu ziskavas ochranu proti kouzlu Blood Oath" );
				
				return true;
			}
			else
			   from.SendLocalizedMessage( 1070772 ); // You must wait a few seconds before you can use that item.
				
			return false;
		}
		
		private static Hashtable m_Table = new Hashtable();
		
		public static bool IsActive( Mobile m )
		{
			if( m != null && m_Table[m] != null )
				return true;
			
			return false;
		}
		
		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;

			public ExpireTimer( Mobile m, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
            Priority = TimerPriority.TwoFiftyMS;
			}

			protected override void OnTick()
			{
				Stop();

				m_Mobile.PlaySound( 0x455 );
				m_Table.Remove( m_Mobile );
				m_Mobile.SendMessage( "Ucinek lecive medoviny skoncil" );
			}
		}
		
		private static void ReleaseMedovinaLock( object state )
		{
			((Mobile)state).EndAction( typeof( Medovina ) );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}