using System;
using Server;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class PekelnyParek : BaseMagicalFood
	{
		[Constructable]
		public PekelnyParek() : base( 2497 )
		{
			Name = "Pekelny Parek";
			Hue = 2622;
		}
		
		public PekelnyParek( Serial serial ) : base( serial )
		{
		}
		
		public override bool Eat( Mobile from )
		{
			if ( KhaldunSummoner.IsUnderInfluence( from ) ) //Plague
			{
				KhaldunSummoner.CurePlague( from );
				from.RevealingAction();
				Consume();
				return false;
			}
			else
			{
				if ( IsActive( from ) )
				{
					from.SendLocalizedMessage( 1005559 ); // This spell is already in effect.
					return false;
				}
				else if ( from.BeginAction( typeof( PekelnyParek ) ) )
				{
  					from.RevealingAction();
  					from.FixedParticles( 0x37C4, 1, 31, 9502, 2021, 2, EffectLayer.Waist );
  					from.PlaySound( 0x5C1 );
  					from.PlaySound( 0x20F );
  					
  					ExpireTimer t = new ExpireTimer( from, TimeSpan.FromMinutes( 5.0 ) );
  					t.Start();
  					m_Table[from] = t;
  					
  					from.SendMessage( "Chut pekelneho parku ti udelila {0}% sanci na kriticky zasah na dobu 5 minut", CritChance( from ) );
  					Timer.DelayCall( TimeSpan.FromMinutes( 10.0 ), new TimerStateCallback( ReleasePekelnyParekLock ), from );
  					Consume();
  					return true;
             }
		      else
			     from.SendLocalizedMessage( 1070772 ); // You must wait a few seconds before you can use that item.
			}
		
			return false;
		}
		
		private static Hashtable m_Table = new Hashtable();
		
		public static bool IsActive( Mobile m )
		{
			if( m != null && m_Table[m] != null )
				return true;
			
			return false;
		}
		
		public static int CritChance( Mobile from )
		{
			return Math.Min( 30, Math.Max( 1, from.Luck / 100 ) );
		}
		
		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;

			public ExpireTimer( Mobile m, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
            Priority = TimerPriority.FiveSeconds;
			}

			protected override void OnTick()
			{
				Stop();

				m_Mobile.PlaySound( 0x5C2 );
				m_Table.Remove( m_Mobile );
				m_Mobile.SendMessage( "Ucinek pekelneho parku skoncil" );
			}
		}
		
		private static void ReleasePekelnyParekLock( object state )
		{
			((Mobile)state).EndAction( typeof( PekelnyParek ) );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
