using System;
using Server;

namespace Server.Items
{
	public class RingOfTheElements : GoldRing
	{
		public override int LabelNumber{ get{ return 1061104; } } // Ring of the Elements
		public override int ArtifactRarity{ get{ return 11; } }

		[Constructable]
		public RingOfTheElements()
		{
			Hue = 0x4E9;
			SkillBonuses.SetValues( 0, SkillName.MagicResist, 5.0 );
			SkillBonuses.SetValues( 1, SkillName.Parry, 5.0 );
			Attributes.BonusStam = 8;
		}

		public RingOfTheElements( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}