using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
    public class UnholyBone : Item, ICarvable
    {
        private SpawnTimer m_Timer;

        public override string DefaultName
        {
            get { return "unholy bone"; }
        }

        [Constructable]
        public UnholyBone() : base(0xF7E)
        {
            Movable = false;
            Hue = 0x497;

            m_Timer = new SpawnTimer(this);
            m_Timer.Start();
        }

        public void Carve(Mobile from, Item item)
        {
            Effects.PlaySound(GetWorldLocation(), Map, 0x48F);
            Effects.SendLocationEffect(GetWorldLocation(), Map, 0x3728, 10, 10, 0, 0);

            if (0.3 > Utility.RandomDouble())
            {
                if (ItemID == 0xF7E)
                    from.SendMessage("You destroy the bone.");
                else
                    from.SendMessage("You destroy the bone pile.");

                Gold gold = new Gold(25, 100);

                gold.MoveToWorld(GetWorldLocation(), Map);

                Delete();

                m_Timer.Stop();
            }
            else
            {
                if (ItemID == 0xF7E)
                    from.SendMessage("You damage the bone.");
                else
                    from.SendMessage("You damage the bone pile.");
            }
        }

        public UnholyBone(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            m_Timer = new SpawnTimer(this);
            m_Timer.Start();
        }

        private class SpawnTimer : Timer
        {
            private Item m_Item;

            public SpawnTimer(Item item) : base(TimeSpan.FromSeconds(Utility.RandomMinMax(5, 10)))
            {
                Priority = TimerPriority.FiftyMS;

                m_Item = item;
            }

            protected override void OnTick()
            {
                if (m_Item.Deleted)
                    return;

                BaseCreature spawn;

                switch (Utility.Random(19))
                {
                    default:
                    case 0: spawn = new Skeleton(); break;
                    case 1: spawn = new Zombie(); break;
                    case 2: spawn = new Wraith(); break;
                    case 3: spawn = new Spectre(); break;
                    case 4: spawn = new Ghoul(); break;
                    case 5: spawn = new Mummy(); break;
                    case 6: spawn = new Bogle(); break;
                    case 7: spawn = new RottingCorpse(); break;
                    case 8: spawn = new BoneKnight(); break;
                    case 9: spawn = new SkeletalKnight(); break;
                    case 10: spawn = new Lich(); break;
                    case 11: spawn = new LichLord(); break;

                    case 12: spawn = new BoneWarrior(); break;
                    case 13: spawn = new BoneWarriorArcher(); break;
                    case 14: spawn = new BoneWarriorKnight(); break;
                    case 15: spawn = new BoneWarriorMage(); break;
                    case 16: spawn = new GhoulLord(); break;
                    case 17: spawn = new SkeletalArcher(); break;
                    case 18: spawn = new WalkingDead(); break;
                }

                TimeSpan duration = TimeSpan.FromMinutes(5.1);

                new Spells.UnsummonTimer(null, spawn, duration).Start();
                spawn.SummonEnd = DateTime.Now + duration;

                if (Utility.RandomDouble() < 0.2/* && !Spells.SpellHelper.IsPandemonium( m_Item.Map, m_Item.Location )*/ )
                    spawn.IsParagon = true;

                if (Teragon.CheckConvert(spawn, m_Item.Location, m_Item.Map))
                    spawn.IsTeragon = true;

                spawn.MoveToWorld(m_Item.Location, m_Item.Map);
                Effects.PlaySound(m_Item.Location, m_Item.Map, spawn.GetAngerSound());

                m_Item.Delete();
            }
        }
    }
}