using System;
using Server;

namespace Server.Items
{
	public class ArcaneShield : WoodenKiteShield
	{
		public override int LabelNumber{ get{ return 1061101; } } // Arcane Shield 
		public override int ArtifactRarity{ get{ return 11; } }
		
		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public ArcaneShield()
		{
			ItemID = 0x1B78;
			Hue = 0x556;
			Attributes.NightSight = 1;
			Attributes.BonusInt = 5;
			Attributes.LowerRegCost = 15;
			Attributes.CastSpeed = 1;
			SkillBonuses.SetValues( 0, SkillName.MagicResist, 5 );
			IsUWItem = true;
			ProtectionLevel = ArmorProtectionLevel.Defense;
			Durability = ArmorDurabilityLevel.Substantial;
		}

		public ArcaneShield( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Attributes.NightSight == 0 )
				Attributes.NightSight = 1;
		}
	}
}