using System;
using Server;
using Server.Guilds;

namespace Server.Items
{
	public class HolyShield : OrderShield
	{
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		public override int ArtifactRarity{ get{ return 15; } }
		
		[Constructable]
		public HolyShield()
		{
			Hue = 0x482;
			Name = "The Holy Shield";
			LootType = LootType.Blessed;

			ArmorAttributes.SelfRepair = 10;
			ArmorAttributes.LowerStatReq = 100;
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			list.Add( 1072376, "2" );
						
			if ( this.Parent is Mobile )
			{
				if ( this.Hue == 1976 )
				{
					list.Add( 1072377 );
					list.Add( "Demon Slayer (total)" );
				}
			}
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			if ( this.Hue == 0x482 )
			{
				list.Add( 1072378 );
				list.Add( 1072382, "4" );
				list.Add( 1072383, "2" );
				list.Add( 1072384, "2" );
				list.Add( 1072385, "2" );
				list.Add( 1072386, "2" );
				list.Add( 1073489, "500" );//luck ~1_val~ (total)	1073489
				list.Add( "Demon Slayer (total)" );
			}
		}
		
		public override bool OnEquip( Mobile from )
		{
			
			BaseWeapon sword = from.FindItemOnLayer(Layer.OneHanded) as BaseWeapon;
			
			if ( sword != null && sword.GetType() == typeof( HolySword ) )
			{
				Effects.PlaySound( from.Location, from.Map, 503 );
				from.FixedParticles( 0x376A, 9, 32, 5030, EffectLayer.Waist );
				
				Hue = 1976;
				PhysicalBonus = 4;
				FireBonus = 2;
				ColdBonus = 2;
				PoisonBonus = 2;
				EnergyBonus = 2;
			   Attributes.Luck = 500;
				
            sword.Hue = 1976;
				sword.Slayer2 = SlayerName.Exorcism;
         }
			this.InvalidateProperties();
			return base.OnEquip( from );	
		}
		
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile m = ( Mobile )parent;

				PhysicalBonus = 0;
				FireBonus = 0;
				ColdBonus = 0;
				PoisonBonus = 0;
				EnergyBonus = 0;
				Attributes.Luck = 0;				
				Hue = 0x482;

				if ( m.FindItemOnLayer( Layer.OneHanded ) is HolySword )
				{
					BaseWeapon sword = m.FindItemOnLayer(Layer.OneHanded) as BaseWeapon;
					sword.Hue = 0x482;
					sword.Slayer2 = SlayerName.None;
				}
				this.InvalidateProperties();
			}
			base.OnRemoved( parent );
		}
		
		public HolyShield( Serial serial ) : base(serial)
		{
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 6.0 )
				Weight = 7.0;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 );//version
		}
	}
}