using System;
using Server;

namespace Server.Items
{
	public class HolySword : Longsword
	{
		public override int LabelNumber{ get{ return 1062921; } } // The Holy Sword

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		public override int ArtifactRarity{ get{ return 15; } }

		[Constructable]
		public HolySword()
		{
			Hue = 0x482;
			LootType = LootType.Blessed;

			Slayer = SlayerName.Silver;

			Attributes.WeaponDamage = 40;
			WeaponAttributes.SelfRepair = 10;
			WeaponAttributes.LowerStatReq = 100;
			WeaponAttributes.UseBestSkill = 1;
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			list.Add( 1072376, "2" );
						
			if ( this.Parent is Mobile )
			{
				if ( this.Hue == 1976 )
				{
					list.Add( 1072377 );
					list.Add( 1073489, "500" );//luck ~1_val~ (total)	1073489
				}
			}
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			if ( this.Hue == 0x482 )
			{
				list.Add( 1072378 );
				list.Add( 1072382, "4" );
				list.Add( 1072383, "2" );
				list.Add( 1072384, "2" );
				list.Add( 1072385, "2" );
				list.Add( 1072386, "2" );
				list.Add( 1073489, "500" );//luck ~1_val~ (total)	1073489
				list.Add( "Demon Slayer (total)" );
			}
		}
		
		public override bool OnEquip( Mobile from )
		{
			
			BaseShield shield = from.FindItemOnLayer(Layer.TwoHanded) as BaseShield;
			
			if ( shield != null && shield.GetType() == typeof( HolyShield ) )
			{
				Effects.PlaySound( from.Location, from.Map, 503 );
				from.FixedParticles( 0x376A, 9, 32, 5030, EffectLayer.Waist );
				
				Hue = 1976;
				Slayer2 = SlayerName.Exorcism;
				
				shield.Hue = 1976;
				shield.PhysicalBonus = 4;
				shield.FireBonus = 2;
				shield.ColdBonus = 2;
				shield.PoisonBonus = 2;
				shield.EnergyBonus = 2;
			   shield.Attributes.Luck = 500;
         }
			this.InvalidateProperties();
			return base.OnEquip( from );	
		}
		
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile m = ( Mobile )parent;
				Hue = 0x482;
				Slayer2 = SlayerName.None;

				if ( m.FindItemOnLayer( Layer.TwoHanded ) is HolyShield )
				{
					BaseShield shield = m.FindItemOnLayer(Layer.TwoHanded) as BaseShield;
					shield.Hue = 0x482;
					shield.Attributes.Luck = 0;
					shield.PhysicalBonus = 0;
					shield.FireBonus = 0;
					shield.ColdBonus = 0;
					shield.PoisonBonus = 0;
					shield.EnergyBonus = 0;
				}
				this.InvalidateProperties();
			}
			base.OnRemoved( parent );
		}

		public HolySword( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 0 ); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}