using System; 
using Server; 
using Server.Items;

namespace Server.Items 
{ 
	public class BagOf1000Boards : Bag 
	{ 
		[Constructable] 
		public BagOf1000Boards() : this( 1000 ) 
		{ 
		} 

		[Constructable] 
		public BagOf1000Boards( int amount ) 
		{ 
			DropItem( new Board( amount ) );
		} 

		public BagOf1000Boards( Serial serial ) : base( serial ) 
		{ 
		} 

		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 

			writer.Write( (int) 0 ); // version 
		} 

		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 

			int version = reader.ReadInt(); 
		} 
	} 
} 
