using System;
using Server;
using Server.Items;
using System.Collections;

namespace Server.Items
{
	public class RandomGlassesBag : Bag
	{
		public static Type[] Brejle { get { return m_Brejle; } }

		private static Type[] m_Brejle = new Type[]
		{
         typeof( AnthropomorphistReadingGlasses ), typeof( FoldedSteelReadingGlasses ), typeof( LightoftheWayReadingGlasses ),
			typeof( LyricalReadingGlasses ), typeof( MaceandShieldReadingGlasses ), typeof( MaritimeReadingGlasses ),
			typeof( NecromanticReadingGlasses ), typeof( PoisonedReadingGlasses ), typeof( Glasses ),
			typeof( ReadingGlassesoftheArts ), typeof( ReadingGlassesoftheTrades ), typeof( TreasuresandTrinketsReadingGlasses )
		};
      
      public override string DefaultName
		{
			get { return "a glasses bag"; }
		}

		[Constructable]
		public RandomGlassesBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomGlassesBag( int amount )
		{
			Movable = true;
			Hue = 1168;
         for ( int i = 0; i < amount; ++i )
			   DropItem( (Item)Activator.CreateInstance( m_Brejle[Utility.Random(m_Brejle.Length)] ) );
		}
		
		public RandomGlassesBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}