using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class RandomLevelClothingBag : Bag
	{
		public override string DefaultName
		{
			get { return "a level clothing bag"; }
		}

		[Constructable]
		public RandomLevelClothingBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomLevelClothingBag( int amount )
		{
			Movable = true;
			Hue = 100;

         for ( int i = 0; i < amount; ++i )
			   DropItem( Loot.RandomLevelClothing( true ) );
		}
		
		public RandomLevelClothingBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}