using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class RandomLevelItemBag : Bag
	{
		public override string DefaultName
		{
			get { return "a level item bag"; }
		}

		[Constructable]
		public RandomLevelItemBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomLevelItemBag( int amount )
		{
			Movable = true;
			Hue = 100;
         for ( int i = 0; i < amount; ++i )
			   DropItem( Loot.RandomLevelItem( true ) );
		}
		
		public RandomLevelItemBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}