using System;
using Server;
using Server.Items;
using System.Collections;

namespace Server.Items
{
	public class RandomLibraryTalismanBag : Bag
	{
		public static Type[] Predmet { get { return m_Predmet; } }

		private static Type[] m_Predmet = new Type[]
		{
         typeof( TreatiseonAlchemyTalisman ), typeof( PrimerOnArmsTalisman ), typeof( MyBookTalisman ),
			typeof( TalkingtoWispsTalisman ), typeof( GrammarOfOrchishTalisman ), typeof( BirdsofBritanniaTalisman ),
			typeof( TheLifeOfTravelingMinstrelTalisman )
		};
      
      public override string DefaultName
		{
			get { return "a library talisman bag"; }
		}

		[Constructable]
		public RandomLibraryTalismanBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomLibraryTalismanBag( int amount )
		{
			Movable = true;
			Hue = 1171;
         for ( int i = 0; i < amount; ++i )
			   DropItem( (Item)Activator.CreateInstance( m_Predmet[Utility.Random(m_Predmet.Length)] ) );
		}
		
		public RandomLibraryTalismanBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}