using System;
using Server;
using Server.Items;
using System.Collections;

namespace Server.Items
{
	public class RandomPlateOfHonorBag : Bag
	{
		public static Type[] Plate { get { return m_Plate; } }

		private static Type[] m_Plate = new Type[]
		{
         typeof( PlateOfHonorArms ), typeof( PlateOfHonorGloves ), typeof( PlateOfHonorGorget ),
			typeof( PlateOfHonorHelm ), typeof( PlateOfHonorChest ), typeof( PlateOfHonorLegs )
		};
      
      public override string DefaultName
		{
			get { return "a plate of honor bag"; }
		}

		[Constructable]
		public RandomPlateOfHonorBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomPlateOfHonorBag( int amount )
		{
			Movable = true;
			Hue = 0x47E;
			
			if ( amount > 1 )
			{
            for ( int i = 0; i < m_Plate.Length; ++i )
			      DropItem( (Item)Activator.CreateInstance( m_Plate[ i ] ) );
         }
         else
         {
            for ( int i = 0; i < amount; ++i )
			      DropItem( (Item)Activator.CreateInstance( m_Plate[ Utility.Random(m_Plate.Length) ] ) );
         }
		}
		
		public RandomPlateOfHonorBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}