using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class RandomRunicToolBag : Bag
	{
		public override string DefaultName
		{
			get { return "a runic tool bag"; }
		}

		[Constructable]
		public RandomRunicToolBag() : this( 1 )
		{
		}

		[Constructable]
		public RandomRunicToolBag( int amount )
		{
			Movable = true;
			Hue = 269;
         for ( int i = 0; i < amount; ++i )
			   DropItem( Loot.RandomRunicTool() );
		}
		
		public RandomRunicToolBag( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}