using System;
using Server;

namespace Server.Items
{
    public class ISTile1 : Item
    {
        private int m_Damage;

        [CommandProperty(AccessLevel.GameMaster)]
        public int Damage
        {
            get { return m_Damage; }
            set
            {
                m_Damage = value;
                if ( m_Damage < 1 ) m_Damage = 1;
                Name = String.Format( "flamestrike trap [{0}% dmg]", m_Damage );
            }
        }

        [Constructable]
        public ISTile1() : this( 30 )
        {
        }
        
        [Constructable]
        public ISTile1( int damage ) : base( 1313 )
        {
            Weight = 1.0;
            Visible = false;
            Movable = false;
            Hue = 1;
            m_Damage = damage;
            Name = String.Format( "flamestrike trap [{0}% dmg]", m_Damage );
        }

        public ISTile1(Serial serial) : base(serial)
        {
        }

        public override bool OnMoveOver(Mobile m)
        {
            if (!m.Player || !m.Alive || m.Blessed || m.AccessLevel > AccessLevel.Player)
                return true;
            
            if ( !BaseTrap.CheckResisted( m ) )
            {
               m.RevealingAction();
               m.FixedParticles(0x3709, 10, 30, 5052, EffectLayer.Waist);
               m.PlaySound(0x208);
               int dmg = Engines.XmlSpawner2.XmlSpecial.PercentualDamage( ISTile5.GetDamage( m_Damage, m ), m );
               m.Hits -= dmg;
               ISTile5.SendDmgPacket( m, dmg );
               if (m.Hits < 2)
                  m.Kill();
            }
            
            return true;
        }

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 ); // version
			
			writer.Write( m_Damage );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch( version )
			{
				case 1:
				{
					m_Damage = reader.ReadInt();
					goto case 0;
				}
            case 0:
				{
					if ( version < 1 )
					{
                  m_Damage = 50;
               }
               Name = String.Format( "flamestrike trap [{0}% dmg]", m_Damage );
					break;
				}
			}
		}
    }
}