using System;
using Server;

namespace Server.Items
{
	public class AxeOfTheHeavens : DoubleAxe
	{
		public override int LabelNumber{ get{ return 1061106; } } // Axe of the Heavens
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public AxeOfTheHeavens()
		{
			Hue = 0x4D5;
			WeaponAttributes.HitLightning = 50;
			IsUWItem = true;
			DamageLevel = WeaponDamageLevel.Power;
			AccuracyLevel = WeaponAccuracyLevel.Surpassingly;
		}

		public AxeOfTheHeavens( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}