using System;
using Server;

namespace Server.Items
{
	public class BladeOfInsanity : Katana
	{
		public override int LabelNumber{ get{ return 1061088; } } // Blade of Insanity
		public override int ArtifactRarity{ get{ return 11; } }
		
		public override int OldMinDamage{ get{ return 7; } }
		public override int OldSpeed{ get{ return 62; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public BladeOfInsanity()
		{
			Hue = 0x76D;
			WeaponAttributes.HitLeechStam = 15;
			Attributes.RegenStam = 2;
			AccuracyLevel = WeaponAccuracyLevel.Supremely;
			DamageLevel = WeaponDamageLevel.Force;
			IsUWItem = true;
		}

		public BladeOfInsanity( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Hue == 0x44F )
				Hue = 0x76D;
		}
	}
}