using System;
using Server;

namespace Server.Items
{
	public class BoneCrusher : WarMace
	{
		public override int LabelNumber{ get{ return 1061596; } } // Bone Crusher
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public BoneCrusher()
		{
			ItemID = 0x1406;
			Hue = 0x60C;
			Attributes.BonusStr = 10;
			DamageLevel = WeaponDamageLevel.Vanq;
			DurabilityLevel = WeaponDurabilityLevel.Massive;
			AccuracyLevel = WeaponAccuracyLevel.Exceedingly;
			IsUWItem = true;
		}

		public BoneCrusher( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Hue == 0x604 )
				Hue = 0x60C;

			if ( ItemID == 0x1407 )
				ItemID = 0x1406;
		}
	}
}