using System;
using Server;

namespace Server.Items
{
	public class Frostbringer : Bow
	{
		public override int LabelNumber{ get{ return 1061111; } } // Frostbringer
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public Frostbringer()
		{
			Hue = 0x4F2;
			Attributes.BonusStam = 10;
			Attributes.RegenStam = 3;
			AccuracyLevel = WeaponAccuracyLevel.Accurate;
			DurabilityLevel = WeaponDurabilityLevel.Fortified;
			DamageLevel = WeaponDamageLevel.Vanq;
			IsUWItem = true;
		}

/* 		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			phys = fire = pois = nrgy = 0;
			cold = 100;
		}
 */
		public Frostbringer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}