using System;
using Server;

namespace Server.Items
{
	public class TheBeserkersMaul : Maul
	{
		public override int LabelNumber{ get{ return 1061108; } } // The Berserker's Maul
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public TheBeserkersMaul()
		{
			Hue = 0x21;
			WeaponAttributes.SelfRepair += 10;
			AccuracyLevel = WeaponAccuracyLevel.Supremely;
			DurabilityLevel = WeaponDurabilityLevel.Indestructible;
			DamageLevel = WeaponDamageLevel.Vanq;
			IsUWItem = true;
		}

		public TheBeserkersMaul( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}