using System;
using Server;

namespace Server.Items
{
	public class TheDryadBow : Bow
	{
		public override int LabelNumber{ get{ return 1061090; } } // The Dryad Bow
		public override int ArtifactRarity{ get{ return 11; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public TheDryadBow()
		{
			ItemID = 0x13B1;
			Hue = 0x48F;
			SkillBonuses.SetValues( 0, m_PossibleBonusSkills[Utility.Random(m_PossibleBonusSkills.Length)], (Utility.Random( 4 ) == 0 ? 5.0 : 10.0) );
			WeaponAttributes.SelfRepair = 5;
			AccuracyLevel = WeaponAccuracyLevel.Supremely;
			DurabilityLevel = WeaponDurabilityLevel.Substantial;
			DamageLevel = WeaponDamageLevel.Vanq;
			IsUWItem = true;
		}

		private static SkillName[] m_PossibleBonusSkills = new SkillName[]
			{
				// SkillName.Swords,
				// SkillName.Fencing,
				// SkillName.Macing,
				SkillName.Archery,
				// SkillName.Wrestling,
				// SkillName.Parry,
				SkillName.Tactics,
				SkillName.Anatomy
				// SkillName.Healing,
				// SkillName.Magery,
				// SkillName.Meditation,
				// SkillName.EvalInt,
				// SkillName.MagicResist,
				// SkillName.AnimalTaming,
				// SkillName.AnimalLore,
				// SkillName.Veterinary,
				// SkillName.Musicianship,
				// SkillName.Provocation,
				// SkillName.Discordance,
				// SkillName.Peacemaking,
				// SkillName.Chivalry,
				// SkillName.Focus,
				// SkillName.Necromancy,
				// SkillName.Stealing,
				// SkillName.Stealth,
				// SkillName.SpiritSpeak 
			};

		public TheDryadBow( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( version < 1 )
				SkillBonuses.SetValues( 0, m_PossibleBonusSkills[Utility.Random(m_PossibleBonusSkills.Length)], (Utility.Random( 4 ) == 0 ? 10.0 : 5.0) );
		}
	}
}
