using System;
using Server;

namespace Server.Items
{
	public class TitansHammer : WarHammer
	{
		public override int LabelNumber{ get{ return 1060024; } } // Titan's Hammer
		public override int ArtifactRarity{ get{ return 10; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public TitansHammer()
		{
			Hue = 0x482;
			WeaponAttributes.HitLeechHits = 10;
			Attributes.BonusStr = 15;
			WeaponAttributes.SelfRepair = 3;
			DurabilityLevel = WeaponDurabilityLevel.Fortified;
			DamageLevel = WeaponDamageLevel.Vanq;
			AccuracyLevel = WeaponAccuracyLevel.Exceedingly;
			IsUWItem = true;
		}

		public TitansHammer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}