using System;
using Server.Items;
using Server.Network;
using Server.Spells;

namespace Server.Items
{
	public abstract class MagicRanged : BaseMeleeWeapon
	{
		public abstract int EffectID{ get; }
		public abstract int EffectHue{ get; }
		public override int DefHitSound{ get{ return 0x234; } }
		public override int DefMissSound{ get{ return 0x238; } }

		public override SkillName DefSkill{ get{ return SkillName.Archery; } }
		public override WeaponType DefType{ get{ return WeaponType.Ranged; } }
		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.ShootXBow; } }
      
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.ParalyzingBlow; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.MortalStrike; } }

		private bool m_Balanced;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Balanced
		{
			get{ return m_Balanced; }
			set{ m_Balanced = value; InvalidateProperties(); }
		}
		
		public MagicRanged( int itemID ) : base( itemID )
		{

		}

		public MagicRanged( Serial serial) : base( serial)
		{

		}

		public override TimeSpan OnSwing( Mobile attacker, Mobile defender )
		{
			// Make sure we've been standing still for one second ( Reduced 50% )
			if ( DateTime.Now > (attacker.LastMoveTime + TimeSpan.FromSeconds( 0.75 )) || (Core.AOS && WeaponAbility.GetCurrentAbility( attacker ) is MovingShot) || (m_Balanced) )
			{
				bool canSwing = true;

				if ( Core.AOS )
				{
					canSwing = ( !attacker.Paralyzed && !attacker.Frozen );

					if ( canSwing )
					{
						Spell sp = attacker.Spell as Spell;

						canSwing = ( sp == null || !sp.IsCasting || !sp.BlocksMovement );
					}
				}
            
            if ( attacker.Mana < 2 )
				{
// 					attacker.SendMessage( "Nemas dostatek many pro vystrel z teto zbrane" );
					return TimeSpan.FromSeconds( 0.25 );
				}
				else if ( canSwing && attacker.HarmfulCheck( defender ) )
				{
					attacker.DisruptiveAction();
					attacker.Send( new Swing( 0, attacker, defender ) );

					if ( OnFired( attacker, defender ) )
					{
						attacker.Mana -= 5;
						if ( CheckHit( attacker, defender ) )
							OnHit( attacker, defender );
						else
							OnMiss( attacker, defender );
					}

				}
				
				attacker.RevealingAction();

				return GetDelay( attacker );
			}
			else
			{
				return TimeSpan.FromSeconds( 0.25 );
			}
		}

		public override void OnHit( Mobile attacker, Mobile defender )
		{
			base.OnHit( attacker, defender );
		}

		public override void OnMiss( Mobile attacker, Mobile defender )
		{
			base.OnMiss( attacker, defender );
		}

		public virtual bool OnFired( Mobile attacker, Mobile defender )
		{
			attacker.MovingEffect( defender, EffectID, 15, 0, false, true, EffectHue, 0 );
			// attacker.MovingEffect( defender, EffectID, 18, 1, false, false );

			return true;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 2 ); // version
			writer.Write( (bool) m_Balanced );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 2:
					{
						m_Balanced = reader.ReadBool();
						break;
					}
				case 1:
					{
						break;
					}
				case 0:
					{
						/*m_EffectID =*/ reader.ReadInt();
						break;
					}
			}
		}
	}
}
